/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.service.admin.impl;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.dao.admin.IFwOrgDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwUser;
import com.kdgc.framework.web.service.admin.IFwOrgService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="FwOrgServiceImpl")
public class FwOrgServiceImpl
extends BaseServiceImpl<FwOrg, Long>
implements IFwOrgService {
    @Resource(name="FwOrgDaoImpl")
    private IFwOrgDao fwOrgDao;

    @Resource(name="FwOrgDaoImpl")
    public void setBaseDao(IFwOrgDao fwOrgDao) {
        super.setBaseDao(fwOrgDao);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwOrg> findChildOrgs(Long parentId, String orgName) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<Order> orders = new ArrayList<Order>();
        filters.add(Filter.eq("pId", parentId));
        filters.add(Filter.eq("status", (Object)StatusEnum.Y));
        if (StringUtils.isNotBlank((String)orgName)) {
            filters.add(Filter.like("orgName", "%" + orgName + "%"));
        }
        orders.add(Order.asc("orderNo"));
        List<FwOrg> fwOrgs = super.findList(null, filters, orders);
        return fwOrgs;
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwOrg> findChargeOrgs(FwUser fwUser) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<Order> orders = new ArrayList<Order>();
        filters.add(Filter.eq("chargeLeader", fwUser));
        filters.add(Filter.eq("status", (Object)StatusEnum.Y));
        orders.add(Order.asc("orderNo"));
        return super.findList(null, filters, orders);
    }

    @Override
    @Transactional(readOnly=true)
    public FwOrg findFwOrgs(Long deptId) {
        return this.fwOrgDao.findFwOrgs(deptId);
    }

    @Override
    @Transactional(readOnly=true)
    public FwOrg findByOrgCode(String orgCode) {
        return this.fwOrgDao.findByOrgCode(orgCode);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwOrg> findLikeOrgName(String orgName) {
        return this.fwOrgDao.findLikeOrgName(orgName);
    }
}

