/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.service.admin.impl;

import com.kdgc.framework.web.service.admin.IFwMailService;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="FwMailServiceImpl")
public class FwMailServiceImpl
implements IFwMailService {
    @Resource(name="javaMailSender")
    private JavaMailSenderImpl javaMailSender;
    @Resource(name="taskExecutor")
    private TaskExecutor taskExecutor;
    @Value(value="${mail.from}")
    private String smtpFromMail;

    private void addSendTask(final MimeMessage mimeMessage) {
        try {
            this.taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    FwMailServiceImpl.this.javaMailSender.send(mimeMessage);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(String toMail, String text, String subject, boolean async) {
        Assert.hasText((String)toMail);
        Assert.hasText((String)subject);
        try {
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, false, "utf-8");
            mimeMessageHelper.setFrom(" <" + this.smtpFromMail + ">");
            mimeMessageHelper.setSubject(subject);
            mimeMessageHelper.setTo(toMail);
            mimeMessageHelper.setText(text, true);
            if (async) {
                this.addSendTask(mimeMessage);
            } else {
                this.javaMailSender.send(mimeMessage);
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }
}

