/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.service.admin.impl;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.dao.admin.IFwDictionaryTypeDao;
import com.kdgc.framework.web.entity.admin.FwDictionary;
import com.kdgc.framework.web.entity.admin.FwDictionaryType;
import com.kdgc.framework.web.service.admin.IFwDictionaryTypeService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Service(value="FwDictionaryTypeServiceImpl")
public class FwDictionaryTypeServiceImpl
extends BaseServiceImpl<FwDictionaryType, Long>
implements IFwDictionaryTypeService {
    @Resource(name="FwDictionaryTypeDaoImpl")
    private IFwDictionaryTypeDao dictionaryTypeDao;

    @Resource(name="FwDictionaryTypeDaoImpl")
    public void setBaseDao(IFwDictionaryTypeDao dictionaryTypeDao) {
        super.setBaseDao(dictionaryTypeDao);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination<FwDictionaryType> findDictionaryTypeList(String typeName, int start, int limit) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (!StringUtils.isEmpty((Object)typeName)) {
            Filter filterName = new Filter("dicTypeName", Filter.Operator.like, "%" + typeName + "%");
            filterList.add(filterName);
        }
        Pageable pageable = new Pageable();
        pageable.setFilters(filterList);
        pageable.setPageSize(limit);
        pageable.setPageNumber((start + limit) / limit);
        return super.findPage(pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination<FwDictionaryType> findDictionaryTypeById(Long id) {
        FwDictionaryType fwDictionaryType = (FwDictionaryType)super.find(id);
        ArrayList<FwDictionaryType> list = new ArrayList<FwDictionaryType>();
        list.add(fwDictionaryType);
        return new Pagination<FwDictionaryType>(list, list.size(), null);
    }

    @Override
    @CacheEvict(value={"dicts"}, allEntries=true)
    public void addDictionaryType(FwDictionaryType dictionaryType) {
        super.save(dictionaryType);
    }

    @Override
    @CacheEvict(value={"dicts"}, allEntries=true)
    public void modifyDictionaryType(FwDictionaryType entity) {
        super.update(entity);
    }

    @Override
    @CacheEvict(value={"dicts"}, allEntries=true)
    public void addDictionary(FwDictionary dictionary, Long dicTypeIdDetail) {
        FwDictionaryType fwDictionaryType = (FwDictionaryType)super.find(dicTypeIdDetail);
        fwDictionaryType.addFwDictionary(dictionary);
        super.update(fwDictionaryType);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination<FwDictionaryType> findDicTypeList(String dicTypeName, Pageable pageable) {
        return this.dictionaryTypeDao.findDicTypeList(dicTypeName, pageable);
    }
}

