/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.service.admin;

import com.kdgc.framework.modules.security.shiro.FwAuthenticationToken;
import com.kdgc.framework.modules.security.shiro.FwCredentialsMatcher;
import com.kdgc.framework.modules.security.shiro.Principal;
import com.kdgc.framework.web.dao.admin.IFwOrgDao;
import com.kdgc.framework.web.dao.admin.IFwUserDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwPermissions;
import com.kdgc.framework.web.entity.admin.FwRoles;
import com.kdgc.framework.web.entity.admin.FwUser;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;

public class ShiroDbRealm
extends AuthorizingRealm {
    @Resource(name="FwUserDaoImpl")
    private IFwUserDao fwUsernDao;
    @Resource(name="FwOrgDaoImpl")
    private IFwOrgDao fwOrgDao;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        FwAuthenticationToken token = (FwAuthenticationToken)authcToken;
        String username = token.getUsername();
        FwUser user = this.fwUsernDao.findByLoginName(username);
        if (user != null) {
            Long userOrgId = FwOrg.orgEnum.company.equals((Object)user.getOrgId().getOrgType()) ? user.getOrgId().getId() : this.findUserOrgId(user.getOrgId().getId());
            return new SimpleAuthenticationInfo((Object)new Principal(user.getId(), user.getLogincode(), user.getUsername(), user.getOrgId().getId(), userOrgId), (Object)user.getPassword(), ByteSource.Util.bytes((byte[])"cpi".getBytes()), this.getName());
        }
        throw new UnknownAccountException();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Principal principal = (Principal)principals.getPrimaryPrincipal();
        if (principal != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            FwUser fwUser = (FwUser)this.fwUsernDao.find(principal.getId());
            if (fwUser != null) {
                for (FwRoles fwRole : fwUser.getFwRoles()) {
                    info.addRole(String.valueOf(fwRole.getId()));
                }
                info.addStringPermissions(this.getPermissonCode(fwUser));
            }
            return info;
        }
        return null;
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        FwCredentialsMatcher matcher = new FwCredentialsMatcher("MD5");
        matcher.setHashIterations(2);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    private Set<String> getPermissonCode(FwUser fwUser) {
        HashSet<String> fwPermissonCode = new HashSet<String>();
        if (fwUser != null) {
            HashSet<FwPermissions> fwPermissons = new HashSet<FwPermissions>();
            fwPermissons.addAll(fwUser.getFwPermissions());
            for (FwRoles role : fwUser.getFwRoles()) {
                fwPermissons.addAll(role.getFwPermissions());
            }
            if (fwUser.getStId() != null) {
                fwPermissons.addAll(fwUser.getStId().getFwPermissions());
            }
            for (FwPermissions fwPermisson : fwPermissons) {
                fwPermissonCode.add(fwPermisson.getPermissionCode());
            }
        }
        return fwPermissonCode;
    }

    private void setSession(Object key, Object value) {
        Session session;
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser && null != (session = currentUser.getSession())) {
            session.setAttribute(key, value);
        }
    }

    private Long findUserOrgId(Long orgId) {
        FwOrg fwOrg = this.fwOrgDao.findParentFwOrg(orgId);
        while (fwOrg != null && !FwOrg.orgEnum.company.equals((Object)fwOrg.getOrgType())) {
            fwOrg = this.fwOrgDao.findParentFwOrg(fwOrg.getId());
        }
        return fwOrg != null ? fwOrg.getId() : null;
    }
}

