/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.service.admin;

import com.kdgc.framework.modules.security.shiro.Principal;
import com.kdgc.framework.web.dao.admin.IFwOrgDao;
import com.kdgc.framework.web.dao.admin.IFwUserDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwPermissions;
import com.kdgc.framework.web.entity.admin.FwRoles;
import com.kdgc.framework.web.entity.admin.FwUser;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasAuthenticationException;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroCasRealm
extends CasRealm {
    private static Logger log = LoggerFactory.getLogger(ShiroCasRealm.class);
    @Resource(name="FwUserDaoImpl")
    private IFwUserDao fwUsernDao;
    @Resource(name="FwOrgDaoImpl")
    private IFwOrgDao fwOrgDao;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        CasToken casToken = (CasToken)token;
        if (token == null) {
            return null;
        }
        String ticket = (String)casToken.getCredentials();
        if (!StringUtils.hasText((String)ticket)) {
            return null;
        }
        TicketValidator ticketValidator = this.ensureTicketValidator();
        try {
            FwUser user;
            boolean isRemembered;
            Assertion casAssertion = ticketValidator.validate(ticket, this.getCasService());
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String userId = casPrincipal.getName();
            log.debug("Validate ticket : {} in CAS server : {} to retrieve user : {}", new Object[]{ticket, this.getCasServerUrlPrefix(), userId});
            Map attributes = casPrincipal.getAttributes();
            casToken.setUserId(userId);
            String rememberMeAttributeName = this.getRememberMeAttributeName();
            String rememberMeStringValue = (String)attributes.get(rememberMeAttributeName);
            boolean bl = isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
            if (isRemembered) {
                casToken.setRememberMe(true);
            }
            if ((user = this.fwUsernDao.findByLoginName(userId)) != null) {
                Long userOrgId = FwOrg.orgEnum.company.equals((Object)user.getOrgId().getOrgType()) ? user.getOrgId().getId() : this.findUserOrgId(user.getOrgId().getId());
                SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)new Principal(user.getId(), user.getLogincode(), user.getUsername(), user.getOrgId().getId(), userOrgId), this.getName());
                return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)ticket);
            }
            return null;
        }
        catch (TicketValidationException e) {
            throw new CasAuthenticationException("Unable to validate ticket [" + ticket + "]", (Throwable)e);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Principal principal = (Principal)principals.getPrimaryPrincipal();
        if (principal != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            FwUser fwUser = (FwUser)this.fwUsernDao.find(principal.getId());
            if (fwUser != null) {
                for (FwRoles fwRole : fwUser.getFwRoles()) {
                    info.addRole(String.valueOf(fwRole.getId()));
                }
                info.addStringPermissions(this.getPermissonCode(fwUser));
            }
            return info;
        }
        return null;
    }

    private Set<String> getPermissonCode(FwUser fwUser) {
        HashSet<String> fwPermissonCode = new HashSet<String>();
        if (fwUser != null) {
            HashSet<FwPermissions> fwPermissons = new HashSet<FwPermissions>();
            fwPermissons.addAll(fwUser.getFwPermissions());
            for (FwRoles role : fwUser.getFwRoles()) {
                fwPermissons.addAll(role.getFwPermissions());
            }
            fwPermissons.addAll(fwUser.getStId().getFwPermissions());
            for (FwPermissions fwPermisson : fwPermissons) {
                fwPermissonCode.add(fwPermisson.getPermissionCode());
            }
        }
        return fwPermissonCode;
    }

    private void setSession(Object key, Object value) {
        Session session;
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser && null != (session = currentUser.getSession())) {
            session.setAttribute(key, value);
        }
    }

    private Long findUserOrgId(Long orgId) {
        FwOrg fwOrg = this.fwOrgDao.findParentFwOrg(orgId);
        while (fwOrg != null && !FwOrg.orgEnum.company.equals((Object)fwOrg.getOrgType())) {
            fwOrg = this.fwOrgDao.findParentFwOrg(fwOrg.getId());
        }
        return fwOrg != null ? fwOrg.getId() : null;
    }
}

