/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.entity.admin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kdgc.framework.dao.model.SortEntity;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwPermissions;
import com.kdgc.framework.web.entity.admin.FwUser;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="FW_STATION")
public class FwStation
extends SortEntity {
    private static final long serialVersionUID = 1L;
    private FwOrg orgId;
    private String stCode;
    private String stName;
    private StatusEnum status;
    private Set<FwUser> fwUsers = new HashSet<FwUser>();
    private Set<FwPermissions> fwPermissions = new HashSet<FwPermissions>();

    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    public FwOrg getOrgId() {
        return this.orgId;
    }

    public void setOrgId(FwOrg orgId) {
        this.orgId = orgId;
    }

    @Column(name="ST_CODE")
    public String getStCode() {
        return this.stCode;
    }

    public void setStCode(String stCode) {
        this.stCode = stCode;
    }

    @Column(name="ST_NAME")
    public String getStName() {
        return this.stName;
    }

    public void setStName(String stName) {
        this.stName = stName;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, length=1)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @OneToMany(mappedBy="stId", fetch=FetchType.LAZY)
    @JsonIgnore
    public Set<FwUser> getFwUsers() {
        return this.fwUsers;
    }

    public void setFwUsers(Set<FwUser> fwUsers) {
        this.fwUsers = fwUsers;
    }

    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JoinTable(name="FW_STATION_PERMISSIONS", joinColumns={@JoinColumn(name="ST_ID")}, inverseJoinColumns={@JoinColumn(name="PERMISSION_ID")})
    @JsonIgnore
    public Set<FwPermissions> getFwPermissions() {
        return this.fwPermissions;
    }

    public void setFwPermissions(Set<FwPermissions> fwPermissions) {
        this.fwPermissions = fwPermissions;
    }

    public void addFwPermissions(FwPermissions fwPermissions) {
        this.fwPermissions.add(fwPermissions);
    }
}

