/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.entity.admin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kdgc.framework.dao.model.SortEntity;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwPermissions;
import com.kdgc.framework.web.entity.admin.FwUser;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="FW_ROLES")
public class FwRoles
extends SortEntity {
    private static final long serialVersionUID = 1L;
    private FwOrg orgId;
    private String roleName;
    private StatusEnum status;
    private String memo;
    private RoleEnum roleType;
    private Set<FwUser> fwUsers = new HashSet<FwUser>();
    private Set<FwPermissions> fwPermissions = new HashSet<FwPermissions>();

    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    public FwOrg getOrgId() {
        return this.orgId;
    }

    public void setOrgId(FwOrg orgId) {
        this.orgId = orgId;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Column(name="ROLE_NAME")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ROLE_TYPE", nullable=false)
    public RoleEnum getRoleType() {
        return this.roleType;
    }

    public void setRoleType(RoleEnum roleType) {
        this.roleType = roleType;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, length=1)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ManyToMany(mappedBy="fwRoles", fetch=FetchType.LAZY)
    @JsonIgnore
    public Set<FwUser> getFwUsers() {
        return this.fwUsers;
    }

    public void setFwUsers(Set<FwUser> fwUsers) {
        this.fwUsers = fwUsers;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="FW_ROLE_PERMISSIONS", joinColumns={@JoinColumn(name="ROLE_ID")}, inverseJoinColumns={@JoinColumn(name="PERMISSION_ID")})
    @OrderBy(value="ID ASC")
    @JsonIgnore
    public Set<FwPermissions> getFwPermissions() {
        return this.fwPermissions;
    }

    public void setFwPermissions(Set<FwPermissions> fwPermissions) {
        this.fwPermissions = fwPermissions;
    }

    @Transient
    public String getOrgName() {
        return this.orgId.getOrgName();
    }

    public static enum RoleEnum {
        superAdmin("\u8d85\u7ea7\u7ba1\u7406\u5458"){

            public String toString() {
                return "\u8d85\u7ea7\u7ba1\u7406\u5458";
            }
        }
        ,
        admin("\u7ba1\u7406\u5458"){

            public String toString() {
                return "\u7ba1\u7406\u5458";
            }
        }
        ,
        user("\u666e\u901a\u7528\u6237"){

            public String toString() {
                return "\u666e\u901a\u7528\u6237";
            }
        };

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

