/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.dao.admin.impl;

import com.kdgc.framework.dao.jpa.impl.BaseDaoImpl;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.modules.utils.DateUtils;
import com.kdgc.framework.modules.utils.StringUtils;
import com.kdgc.framework.web.dao.admin.IFwUserDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwPendingDetails;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;
import com.kdgc.framework.web.entity.admin.FwRoles;
import com.kdgc.framework.web.entity.admin.FwUser;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository(value="FwUserDaoImpl")
public class FwUserDaoImpl
extends BaseDaoImpl<FwUser, Long>
implements IFwUserDao {
    @Override
    public boolean loginNameExists(String loginName) {
        if (loginName == null) {
            return false;
        }
        String jpql = "select count(*) from FwUser fwUser where lower(fwUser.logincode) = lower(:loginName)";
        Long count = (Long)this.entityManager.createQuery(jpql, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("loginName", (Object)loginName).getSingleResult();
        return count > 0L;
    }

    @Override
    public FwUser findByLoginName(String loginName) {
        if (loginName == null) {
            return null;
        }
        try {
            String jpql = "select fwUser from FwUser fwUser join fetch fwUser.orgId  where lower(fwUser.logincode) = lower(:loginName) and fwUser.status=:status";
            return (FwUser)this.entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("loginName", (Object)loginName).setParameter("status", (Object)StatusEnum.Y).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<FwUser> findLikeUserName(String userName) {
        try {
            String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId where fwUser.username like :userName and fwUser.status=:status";
            return this.entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("userName", (Object)("%" + userName + "%")).setParameter("status", (Object)StatusEnum.Y).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public Pagination<FwUser> findLikeUserName(String userName, Pageable pageable) {
        try {
            String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId LEFT JOIN FETCH fwUser.stId where fwUser.username like ?0 and fwUser.status=?1";
            return this.pagerJPQLList(jpql, new Object[]{"%" + userName + "%", StatusEnum.Y}, pageable);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public Pagination<FwUser> findLikeUserName(String userName, long orgId, Pageable pageable) {
        try {
            String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId o LEFT JOIN FETCH fwUser.stId where fwUser.username like ?0 and fwUser.status=?1 and o.id=?2";
            return this.pagerJPQLList(jpql, new Object[]{"%" + userName + "%", StatusEnum.Y, orgId}, pageable);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<FwUser> findUsersByDeptCode(List<String> orgCodes) {
        Calendar beginDate = Calendar.getInstance();
        beginDate.add(4, -1);
        beginDate.set(7, 7);
        Calendar endDate = Calendar.getInstance();
        endDate.set(7, 6);
        Date mindate = DateUtils.getDateMinTime(beginDate.getTime());
        Date maxdate = DateUtils.getDateMaxTime(endDate.getTime());
        String jpql = "select fwUser from FwUser fwUser join fetch fwUser.orgId orgId where orgId.orgCode in (:orgCodes)  and fwUser.status = :status and fwUser.logincode not in  (select pmJRsrc.empCode from PmJHour pmJHour,PmJRsrc pmJRsrc   where pmJRsrc.id = pmJHour.rsrcId.id    and pmJHour.manhourDate between :beginDate and :endDate) order by fwUser.orgId,fwUser.orderNo";
        return this.entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("orgCodes", orgCodes).setParameter("status", (Object)StatusEnum.Y).setParameter("beginDate", (Object)mindate).setParameter("endDate", (Object)maxdate).getResultList();
    }

    @Override
    public List<FwUser> findUsersByDeptAndStCode(List<FwOrg> fwOrgs, String stCode) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
        Root root = criteriaQuery.from(FwUser.class);
        criteriaQuery.select((Selection)root);
        Predicate restrictions = criteriaBuilder.conjunction();
        if (fwOrgs != null && fwOrgs.size() > 0) {
            Iterator<FwOrg> iterator = fwOrgs.iterator();
            CriteriaBuilder.In in = criteriaBuilder.in((Expression)root.get("orgId"));
            while (iterator.hasNext()) {
                in.value((Object)iterator.next());
            }
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)in);
        }
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("status"), (Object)StatusEnum.Y));
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("stId").get("stCode"), (Object)stCode));
        criteriaQuery.where((Expression)restrictions);
        ArrayList<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("orgId"));
        orders.add(Order.asc("orderNo"));
        return super.findList(criteriaQuery, null, null, null, orders);
    }

    @Override
    public List<FwUser> findOrgUsers(FwOrg fwOrg) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
        Root root = criteriaQuery.from(FwUser.class);
        criteriaQuery.select((Selection)root);
        Predicate restrictions = criteriaBuilder.conjunction();
        if (fwOrg != null) {
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("orgId"), (Object)fwOrg));
        }
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("status"), (Object)StatusEnum.Y));
        criteriaQuery.where((Expression)restrictions);
        ArrayList<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("orgId"));
        orders.add(Order.asc("orderNo"));
        return super.findList(criteriaQuery, null, null, null, orders);
    }

    @Override
    public List<FwUser> findUsersNotInOrgs(List<FwOrg> fwOrgs) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
        Root root = criteriaQuery.from(FwUser.class);
        criteriaQuery.select((Selection)root);
        Predicate restrictions = criteriaBuilder.conjunction();
        if (fwOrgs != null && fwOrgs.size() > 0) {
            Iterator<FwOrg> iterator = fwOrgs.iterator();
            CriteriaBuilder.In in = criteriaBuilder.in((Expression)root.get("orgId"));
            while (iterator.hasNext()) {
                in.value((Object)iterator.next());
            }
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.not((Expression)in));
        }
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("status"), (Object)StatusEnum.Y));
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.isNotNull((Expression)root.get("email")));
        criteriaQuery.where((Expression)restrictions);
        ArrayList<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("orgId"));
        orders.add(Order.asc("orderNo"));
        return super.findList(criteriaQuery, null, null, null, orders);
    }

    @Override
    public Pagination<FwUser> findWaitMember(List<Long> memberIds, String queryName, Integer start, Integer limit) {
        StringBuffer resultCount = new StringBuffer("SELECT COUNT(*) FROM FwUser fwUser WHERE 1 = 1 ");
        if (!memberIds.isEmpty()) {
            resultCount.append("AND fwUser.id NOT IN :memberIds ");
        }
        if (!StringUtils.isEmpty((CharSequence)queryName)) {
            resultCount.append("AND fwUser.username LIKE :userName ");
        }
        Query countQuery = this.entityManager.createQuery(resultCount.toString());
        if (!memberIds.isEmpty()) {
            countQuery.setParameter("memberIds", memberIds);
        }
        if (!StringUtils.isEmpty((CharSequence)queryName)) {
            countQuery.setParameter("userName", (Object)("%" + queryName + "%"));
        }
        Long count = Long.parseLong(countQuery.getSingleResult().toString());
        List list = new ArrayList();
        if (count > 0L) {
            StringBuffer jpql = new StringBuffer("SELECT fwUser FROM FwUser fwUser WHERE 1 = 1 ");
            if (!memberIds.isEmpty()) {
                jpql.append("AND fwUser.id NOT IN :memberIds ");
            }
            if (!StringUtils.isEmpty((CharSequence)queryName)) {
                jpql.append("AND fwUser.username LIKE :userName ");
            }
            jpql.append("ORDER BY fwUser.orgId, fwUser.id");
            TypedQuery query = this.entityManager.createQuery(jpql.toString(), FwUser.class);
            if (!memberIds.isEmpty()) {
                query.setParameter("memberIds", memberIds);
            }
            if (!StringUtils.isEmpty((CharSequence)queryName)) {
                query.setParameter("userName", (Object)("%" + queryName + "%"));
            }
            query.setFirstResult(start.intValue());
            query.setMaxResults(start + limit);
            list = query.getResultList();
        }
        Pagination<FwUser> result = new Pagination<FwUser>(list, count, null);
        return result;
    }

    @Override
    public void deleteUser(List<Long> userIds) {
        String jpql = "UPDATE FwUser fwUser SET fwUser.status = 'N' WHERE fwUser.id IN :ids";
        Query query = this.entityManager.createQuery(jpql);
        query.setParameter("ids", userIds);
        query.executeUpdate();
    }

    @Override
    public List<FwUser> findUserAndOrg(String deptId, String userName, int page, int rows) {
        String temp = "";
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            temp = temp + " and fwUser.username like '%" + userName + "%' ";
        }
        if (!StringUtils.isEmpty((CharSequence)deptId)) {
            temp = temp + " and orgId.id = '" + deptId + "' ";
        }
        try {
            String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId orgId where fwUser.status=:status" + temp + " order by orgId.orgCode";
            List list = this.entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("status", (Object)StatusEnum.Y).setFirstResult((page - 1) * rows).setMaxResults(rows).getResultList();
            return list;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public Long getCount(String deptId, String userName) {
        String temp = "";
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            temp = temp + " and fwUser.username like '%" + userName + "%' ";
        }
        if (!StringUtils.isEmpty((CharSequence)deptId)) {
            temp = temp + " and orgId.id = '" + deptId + "' ";
        }
        try {
            String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId orgId where fwUser.status=:status" + temp;
            List list = this.entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("status", (Object)StatusEnum.Y).getResultList();
            return list.size();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<FwUser> findUserByRoleType(FwRoles.RoleEnum roleEnum) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
        Root root = criteriaQuery.from(FwUser.class);
        Join fwRolesJoin = root.join("fwRoles");
        criteriaQuery.select((Selection)root);
        Predicate restrictions = criteriaBuilder.conjunction();
        if (roleEnum != null) {
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)fwRolesJoin.get("roleType"), (Object)roleEnum));
        }
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("status"), (Object)StatusEnum.Y));
        criteriaQuery.where((Expression)restrictions);
        return this.entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
    }

    @Override
    public List<FwUser> findUserByPermisson(String permissionCode) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
        Root root = criteriaQuery.from(FwUser.class);
        Join fwPermissionsJoin = root.join("fwPermissions");
        criteriaQuery.select((Selection)root);
        Predicate restrictions = criteriaBuilder.conjunction();
        if (StringUtils.isNotBlank((CharSequence)permissionCode)) {
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)fwPermissionsJoin.get("permissionCode"), (Object)permissionCode));
        }
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("status"), (Object)StatusEnum.Y));
        criteriaQuery.where((Expression)restrictions);
        return this.entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
    }

    @Override
    public List<FwUser> findUserByRolePermisson(String permissionCode) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
        Root root = criteriaQuery.from(FwUser.class);
        Join fwRolesJoin = root.join("fwRoles");
        Join fwPermissionsJoin = fwRolesJoin.join("fwPermissions");
        criteriaQuery.select((Selection)root);
        Predicate restrictions = criteriaBuilder.conjunction();
        if (permissionCode != null) {
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)fwPermissionsJoin.get("permissionCode"), (Object)permissionCode));
        }
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("status"), (Object)StatusEnum.Y));
        criteriaQuery.where((Expression)restrictions);
        return this.entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
    }

    @Override
    public List<FwUser> findUserByStationPermisson(String permissionCode) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
        Root root = criteriaQuery.from(FwUser.class);
        Join fwStationJoin = root.join("stId");
        Join fwPermissionsJoin = fwStationJoin.join("fwPermissions");
        criteriaQuery.select((Selection)root);
        Predicate restrictions = criteriaBuilder.conjunction();
        if (permissionCode != null) {
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)fwPermissionsJoin.get("permissionCode"), (Object)permissionCode));
        }
        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get("status"), (Object)StatusEnum.Y));
        criteriaQuery.where((Expression)restrictions);
        return this.entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
    }

    @Override
    public Pagination<FwUser> findUserList(Long orgId, String userNameOrCode, Pageable pageable) {
        String tempString = "";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty(orgId)) {
            tempString = tempString + " and fwUser.orgId.id = :orgId ";
            params.put("orgId", orgId);
        }
        if (!StringUtils.isEmpty((CharSequence)userNameOrCode)) {
            tempString = tempString + " and (fwUser.username like '%" + userNameOrCode + "%' or fwUser.logincode like '%" + userNameOrCode + "%')";
        }
        try {
            String jpql = "select distinct fwUser from FwUser fwUser JOIN FETCH fwUser.orgId  fwOrg LEFT JOIN FETCH fwUser.stId fwStation where fwUser.status =:dataStat " + tempString + "order by fwUser.orderNo";
            params.put("dataStat", (Object)StatusEnum.Y);
            return this.pagerJPQLList(jpql, params, pageable);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<FwUser> findNotDealMessage() {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String jpql = "select fwPendingMessage from FwPendingMessage fwPendingMessage  where fwPendingMessage.busiType = :busiType  and fwPendingMessage.isdeal = :isdeal";
        List list = this.entityManager.createQuery(jpql, FwPendingMessage.class).setFlushMode(FlushModeType.COMMIT).setParameter("busiType", (Object)FwPendingMessage.MessageType.pending).setParameter("isdeal", (Object)false).getResultList();
        for (FwPendingMessage entity : list) {
            List<FwPendingDetails> detailList = entity.getFwPendingDetails();
            for (FwPendingDetails detail : detailList) {
                if (detail.getIsDeal() || userIds.contains(detail.getReceiverId())) continue;
                userIds.add(detail.getReceiverId());
            }
        }
        String userjpql = "select fwUser from FwUser fwUser join fetch fwUser.orgId orgId where fwUser.status = :status and fwUser.id in (:userIds) order by fwUser.orgId,fwUser.orderNo";
        return this.entityManager.createQuery(userjpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("userIds", userIds).setParameter("status", (Object)StatusEnum.Y).getResultList();
    }
}

