/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.dao.admin.impl;

import com.kdgc.framework.dao.jpa.impl.BaseDaoImpl;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.web.dao.admin.IFwOrgDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import org.springframework.stereotype.Repository;

@Repository(value="FwOrgDaoImpl")
public class FwOrgDaoImpl
extends BaseDaoImpl<FwOrg, Long>
implements IFwOrgDao {
    @Override
    public FwOrg findFwOrgs(Long deptId) {
        try {
            String jpql = "select distinct fwOrg from FwOrg fwOrg LEFT JOIN FETCH fwOrg.children where fwOrg.status =:status and fwOrg.id=:deptId";
            return (FwOrg)this.entityManager.createQuery(jpql, FwOrg.class).setFlushMode(FlushModeType.COMMIT).setParameter("status", (Object)StatusEnum.Y).setParameter("deptId", (Object)deptId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public FwOrg findParentFwOrg(Long orgId) {
        try {
            String jpql = "select distinct fwOrg.pId from FwOrg fwOrg where fwOrg.status =:status and fwOrg.id=:orgId";
            return (FwOrg)this.entityManager.createQuery(jpql, FwOrg.class).setFlushMode(FlushModeType.COMMIT).setParameter("status", (Object)StatusEnum.Y).setParameter("orgId", (Object)orgId).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public FwOrg findByOrgCode(String orgCode) {
        if (orgCode == null) {
            return null;
        }
        try {
            String jpql = "select fwOrg from FwOrg fwOrg left join fetch fwOrg.children  where lower(fwOrg.orgCode) = lower(:orgCode) and fwOrg.status=:status";
            return (FwOrg)this.entityManager.createQuery(jpql, FwOrg.class).setFlushMode(FlushModeType.COMMIT).setParameter("orgCode", (Object)orgCode).setParameter("status", (Object)StatusEnum.Y).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<FwOrg> findLikeOrgName(String orgName) {
        try {
            String jpql = "select fwOrg from FwOrg fwOrg  where fwOrg.orgName like :orgName and fwOrg.status=:status";
            return this.entityManager.createQuery(jpql, FwOrg.class).setFlushMode(FlushModeType.COMMIT).setParameter("orgName", (Object)("%" + orgName + "%")).setParameter("status", (Object)StatusEnum.Y).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

