/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class AjaxUtil {
    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null ? "XMLHttpRequest".equalsIgnoreCase(requestedWith) : false;
    }

    public static Map getParameterMap(HttpServletRequest request) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        Map reqParams = request.getParameterMap();
        Set entries = reqParams.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (value == null) continue;
            if (value.length == 1) {
                paraMap.put(name, value[0]);
                continue;
            }
            paraMap.put(name, value);
        }
        return paraMap;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.equals("0:0:0:0:0:0:0:1")) {
            ip = "\u672c\u5730";
        }
        return ip;
    }

    public static String getAppbaseUrl(HttpServletRequest request, String url) {
        return request.getContextPath() + url;
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer maxAge, String path, String domain, Boolean secure) {
        Assert.notNull((Object)request);
        Assert.notNull((Object)response);
        Assert.hasText((String)name);
        try {
            name = URLEncoder.encode(name, "UTF-8");
            value = URLEncoder.encode(value, "UTF-8");
            Cookie cookie = new Cookie(name, value);
            if (maxAge != null) {
                cookie.setMaxAge(maxAge.intValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                cookie.setPath(path);
            }
            if (StringUtils.isNotEmpty((CharSequence)domain)) {
                cookie.setDomain(domain);
            }
            if (secure != null) {
                cookie.setSecure(secure.booleanValue());
            }
            response.addCookie(cookie);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        AjaxUtil.addCookie(request, response, name, value, null, "/", null, null);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request);
        Assert.hasText((String)name);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            try {
                name = URLEncoder.encode(name, "UTF-8");
                for (Cookie cookie : cookies) {
                    if (!name.equals(cookie.getName())) continue;
                    return URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name, String path, String domain) {
        Assert.notNull((Object)request);
        Assert.notNull((Object)response);
        Assert.hasText((String)name);
        try {
            name = URLEncoder.encode(name, "UTF-8");
            Cookie cookie = new Cookie(name, null);
            cookie.setMaxAge(0);
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                cookie.setPath(path);
            }
            if (StringUtils.isNotEmpty((CharSequence)domain)) {
                cookie.setDomain(domain);
            }
            response.addCookie(cookie);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

