/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.web.common;

import org.apache.commons.lang.StringUtils;

public class ResponseData {
    public static final ResponseData SUCCESS_NO_DATA = new ResponseData(Type.info, "\u64cd\u4f5c\u6210\u529f");
    public static final ResponseData FAILED_NO_DATA = new ResponseData(Type.error, "\u64cd\u4f5c\u9519\u8bef");
    private boolean success;
    private Type type;
    private String content;
    private Object data;

    public ResponseData(Type type, String content) {
        this.type = type;
        this.content = content;
        switch (type) {
            case error: {
                this.success = false;
                break;
            }
            default: {
                this.success = true;
            }
        }
    }

    public ResponseData(Type type, String content, Object data) {
        this.type = type;
        this.data = data;
        switch (type) {
            case error: {
                this.success = false;
                if (StringUtils.isNotBlank((String)content)) {
                    this.content = content;
                    break;
                }
                this.content = "\u64cd\u4f5c\u9519\u8bef";
                break;
            }
            default: {
                this.success = true;
                this.content = StringUtils.isNotBlank((String)content) ? content : "\u64cd\u4f5c\u6210\u529f";
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public static ResponseData success(String content) {
        return new ResponseData(Type.info, content);
    }

    public static ResponseData success(String content, Object data) {
        return new ResponseData(Type.info, content, data);
    }

    public static ResponseData warn(String content) {
        return new ResponseData(Type.warn, content);
    }

    public static ResponseData warn(String content, Object data) {
        return new ResponseData(Type.warn, content, data);
    }

    public static ResponseData error(String content) {
        return new ResponseData(Type.error, content);
    }

    public static ResponseData error(String content, Object data) {
        return new ResponseData(Type.error, content, data);
    }

    public static ResponseData other(String content) {
        return new ResponseData(Type.other, content);
    }

    public static ResponseData other(String content, Object data) {
        return new ResponseData(Type.other, content, data);
    }

    public static enum Type {
        info,
        warn,
        error,
        other;

    }
}

