/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.service.jpa.impl;

import com.kdgc.framework.dao.jpa.IBaseDao;
import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.service.jpa.IBaseService;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public class BaseServiceImpl<T, ID extends Serializable>
implements IBaseService<T, ID> {
    private static final String[] UPDATE_IGNORE_PROPERTIES = new String[]{"id", "createDate", "modifyDate"};
    private IBaseDao<T, ID> baseDao;

    public void setBaseDao(IBaseDao<T, ID> baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    @Transactional(readOnly=true)
    public T getReference(ID id) {
        return this.baseDao.getReference(id);
    }

    @Override
    @Transactional(readOnly=true)
    public T find(ID id) {
        return this.baseDao.find(id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findAll() {
        return this.findList(null, null, null, null);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findList(ID ... ids) {
        ArrayList<T> result = new ArrayList<T>();
        if (ids != null) {
            for (ID id : ids) {
                T entity = this.find(id);
                if (entity == null) continue;
                result.add(entity);
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findList(Integer count, List<Filter> filters, List<Order> orders) {
        return this.findList(null, count, filters, orders);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findList(Integer first, Integer count, List<Filter> filters, List<Order> orders) {
        return this.baseDao.findList(first, count, filters, orders);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination<T> findPage(Pageable pageable) {
        return this.baseDao.findPage(pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public long count() {
        return this.count(new Filter[0]);
    }

    @Override
    @Transactional(readOnly=true)
    public long count(Filter ... filters) {
        return this.baseDao.count(filters);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean exists(ID id) {
        return this.baseDao.find(id) != null;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean exists(Filter ... filters) {
        return this.baseDao.count(filters) > 0L;
    }

    @Override
    @Transactional
    public void save(T entity) {
        this.baseDao.persist(entity);
    }

    @Override
    @Transactional
    public void batchSave(List<T> entitys) {
        this.baseDao.batchPersist(entitys);
    }

    @Override
    @Transactional
    public T update(T entity) {
        return this.baseDao.merge(entity);
    }

    @Override
    @Transactional
    public void batchUpdate(List<T> entitys) {
        this.baseDao.batchMerge(entitys);
    }

    @Override
    @Transactional
    public T update(T entity, String ... ignoreProperties) {
        Assert.notNull(entity);
        if (this.baseDao.isManaged(entity)) {
            throw new IllegalArgumentException("Entity must not be managed");
        }
        T persistant = this.baseDao.find(this.baseDao.getIdentifier(entity));
        if (persistant != null) {
            this.copyProperties(entity, persistant, (String[])ArrayUtils.addAll((Object[])ignoreProperties, (Object[])UPDATE_IGNORE_PROPERTIES));
            return this.update(persistant);
        }
        return this.update(entity);
    }

    @Override
    @Transactional
    public void delete(ID id) {
        this.delete(this.baseDao.find(id));
    }

    @Override
    @Transactional
    public void delete(ID ... ids) {
        if (ids != null) {
            for (ID id : ids) {
                this.delete(this.baseDao.find(id));
            }
        }
    }

    @Override
    @Transactional
    public void delete(T entity) {
        this.baseDao.remove(entity);
    }

    private void copyProperties(Object source, Object target, String[] ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(target.getClass());
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object sourceValue = readMethod.invoke(source, new Object[0]);
                Object targetValue = readMethod.invoke(target, new Object[0]);
                if (sourceValue != null && targetValue != null && targetValue instanceof Collection) {
                    Collection collection = (Collection)targetValue;
                    collection.clear();
                    collection.addAll((Collection)sourceValue);
                    continue;
                }
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, sourceValue);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties from source to target", ex);
            }
        }
    }
}

