/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.modules.utils;

import java.util.HashMap;
import java.util.Stack;

public class Calculator {
    private static HashMap<String, Integer> opLs;
    private String src;

    public Calculator(String src) {
        this.src = src;
        if (opLs == null) {
            opLs = new HashMap(6);
            opLs.put("+", 0);
            opLs.put("-", 0);
            opLs.put("*", 1);
            opLs.put("\u00d7", 1);
            opLs.put("\u00f7", 1);
            opLs.put("/", 1);
            opLs.put("%", 1);
            opLs.put(")", 2);
        }
    }

    public String toRpn() {
        String[] tmp = this.split(this.src);
        Stack<String> rpn = new Stack<String>();
        Stack<String> tmpSta = new Stack<String>();
        for (String str : tmp) {
            if (this.isNum(str)) {
                rpn.push('(' + str + ')');
                continue;
            }
            if (tmpSta.isEmpty()) {
                tmpSta.push(str);
                continue;
            }
            if (this.isHigh((String)tmpSta.peek(), str)) {
                if (!str.equals(")")) {
                    do {
                        rpn.push((String)tmpSta.peek());
                        tmpSta.pop();
                    } while (!tmpSta.isEmpty() && this.isHigh((String)tmpSta.peek(), str));
                    tmpSta.push(str);
                    continue;
                }
                while (!tmpSta.isEmpty() && !((String)tmpSta.peek()).equals("(")) {
                    rpn.push((String)tmpSta.pop());
                }
                if (tmpSta.empty() || !((String)tmpSta.peek()).equals("(")) continue;
                tmpSta.pop();
                continue;
            }
            if (this.isHigh((String)tmpSta.peek(), str)) continue;
            tmpSta.push(str);
        }
        while (!tmpSta.empty()) {
            rpn.push((String)tmpSta.pop());
        }
        StringBuilder st = new StringBuilder();
        for (String str : rpn) {
            st.append(str);
        }
        rpn.clear();
        return st.toString();
    }

    private String[] split(String src) {
        StringBuilder sb = new StringBuilder(src.length());
        for (char ch : src.toCharArray()) {
            if (ch == '+' || ch == '-' || ch == '*' || ch == '\u00d7' || ch == '/' || ch == '\u00f7' || ch == '(' || ch == ')' || ch == '%') {
                sb.append(",");
                sb.append(ch);
                sb.append(",");
                continue;
            }
            sb.append(ch);
        }
        String string = sb.toString().replaceAll(",{2,}", ",");
        return string.split(",");
    }

    private boolean isHigh(String pop, String str) {
        if (str.equals(")")) {
            return true;
        }
        if (opLs.get(pop) == null || opLs.get(str) == null) {
            return false;
        }
        return opLs.get(pop) >= opLs.get(str);
    }

    public boolean isNum(String str) {
        for (char ch : str.toCharArray()) {
            if (ch != '+' && ch != '-' && ch != '*' && ch != '\u00d7' && ch != '/' && ch != '\u00f7' && ch != '(' && ch != ')' && ch != '%') continue;
            return false;
        }
        return true;
    }

    public double getRes() {
        String rpn = this.toRpn();
        Stack<Double> res = new Stack<Double>();
        StringBuilder sb = new StringBuilder();
        block6: for (char ch : rpn.toCharArray()) {
            if (ch == '(') continue;
            if (ch >= '0' && ch <= '9' || ch == '.') {
                sb.append(ch);
                continue;
            }
            if (ch == ')') {
                res.push(Double.valueOf(sb.toString()));
                sb = new StringBuilder();
                continue;
            }
            if (res.empty()) continue;
            Double x = (Double)res.pop();
            Double y = (Double)res.pop();
            switch (ch) {
                case '+': {
                    res.push(y + x);
                    continue block6;
                }
                case '-': {
                    res.push(y - x);
                    continue block6;
                }
                case '*': 
                case '\u00d7': {
                    res.push(y * x);
                    continue block6;
                }
                case '%': 
                case '/': 
                case '\u00f7': {
                    if (x != 0.0) {
                        double rsd = ch == '%' ? y % x : y / x;
                        res.push(rsd);
                        continue block6;
                    }
                    System.out.println("\u5206\u6bcd\u4e3a\u96f6");
                    res.clear();
                    return -1.0;
                }
            }
        }
        Double result = (Double)res.pop();
        res.clear();
        return result;
    }

    public static boolean checkFormula(String formula) {
        Stack<Character> stack = new Stack<Character>();
        char[] ch = formula.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] != '}' && ch[i] != ']' && ch[i] != ')') {
                stack.push(Character.valueOf(ch[i]));
                continue;
            }
            while (((Character)stack.peek()).charValue() != '{' && ((Character)stack.peek()).charValue() != '[' && ((Character)stack.peek()).charValue() != '(') {
                stack.pop();
            }
            if (ch[i] == '}' && ((Character)stack.peek()).charValue() == '{') {
                stack.pop();
                continue;
            }
            if (ch[i] == ']' && ((Character)stack.peek()).charValue() == '[') {
                stack.pop();
                continue;
            }
            if (ch[i] == ')' && ((Character)stack.peek()).charValue() == '(') {
                stack.pop();
                continue;
            }
            stack.push(Character.valueOf(ch[i]));
        }
        while (!stack.empty() && ((Character)stack.peek()).charValue() != '{' && ((Character)stack.peek()).charValue() != '[' && ((Character)stack.peek()).charValue() != '(') {
            stack.pop();
        }
        return stack.empty();
    }

    public static void main(String[] args) {
        String src2 = "(10*((5+(36)-[\u6d4b\u8bd5]+5+7))-8-3)";
        System.out.println(Calculator.checkFormula(src2));
    }
}

