/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.modules.security.utils;

import com.kdgc.framework.modules.utils.Exceptions;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.shiro.crypto.hash.Md5Hash;

public class Cryptos {
    public static final String HASH_ALGORITHM = "MD5";
    public static final int HASH_INTERATIONS = 2;
    public static final String HASH_SALT = "cpi";
    private static final String AES = "AES";
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private static final String HMACSHA1 = "HmacSHA1";
    private static final int DEFAULT_HMACSHA1_KEYSIZE = 160;
    private static final int DEFAULT_AES_KEYSIZE = 128;
    private static final int DEFAULT_IVSIZE = 16;
    private static SecureRandom random = new SecureRandom();

    public static byte[] hmacSha1(byte[] input, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, HMACSHA1);
            Mac mac = Mac.getInstance(HMACSHA1);
            mac.init(secretKey);
            return mac.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static boolean isMacValid(byte[] expected, byte[] input, byte[] key) {
        byte[] actual = Cryptos.hmacSha1(input, key);
        return Arrays.equals(expected, actual);
    }

    public static byte[] generateHmacSha1Key() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(HMACSHA1);
            keyGenerator.init(160);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key) {
        return Cryptos.aes(input, key, 1);
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key, byte[] iv) {
        return Cryptos.aes(input, key, iv, 1);
    }

    public static String aesDecrypt(byte[] input, byte[] key) {
        byte[] decryptResult = Cryptos.aes(input, key, 2);
        return new String(decryptResult);
    }

    public static String aesDecrypt(byte[] input, byte[] key, byte[] iv) {
        byte[] decryptResult = Cryptos.aes(input, key, iv, 2);
        return new String(decryptResult);
    }

    private static byte[] aes(byte[] input, byte[] key, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(mode, secretKey);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    private static byte[] aes(byte[] input, byte[] key, byte[] iv, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(AES_CBC);
            cipher.init(mode, (Key)secretKey, ivSpec);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] generateAesKey() {
        return Cryptos.generateAesKey(128);
    }

    public static byte[] generateAesKey(int keysize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES);
            keyGenerator.init(keysize);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] generateIV() {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    public static byte[] getKeyByPass() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(AES);
            kg.init(128, new SecureRandom(HASH_SALT.getBytes()));
            SecretKey sk = kg.generateKey();
            byte[] b = sk.getEncoded();
            return b;
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String byteToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String strHex = Integer.toHexString(bytes[i]);
            if (strHex.length() > 3) {
                sb.append(strHex.substring(6));
                continue;
            }
            if (strHex.length() < 2) {
                sb.append("0" + strHex);
                continue;
            }
            sb.append(strHex);
        }
        return sb.toString();
    }

    public static String entryptPassword(String plaintextPassword) {
        Md5Hash md5 = new Md5Hash((Object)plaintextPassword, (Object)HASH_SALT.getBytes(), 2);
        return md5.toString();
    }

    public static String aesEncryptByKey(String originalStr) {
        return Base64.encodeBase64String((byte[])Cryptos.aesEncrypt(originalStr.getBytes(), Cryptos.getKeyByPass()));
    }

    public static String aesDecryptByKey(String encryptStr) {
        return Cryptos.aesDecrypt(Base64.decodeBase64((String)encryptStr), Cryptos.getKeyByPass());
    }
}

