/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.modules.security.shiro;

import com.kdgc.framework.modules.security.shiro.FwAuthenticationToken;
import com.kdgc.framework.modules.security.utils.Cryptos;
import com.kdgc.framework.modules.utils.JSONUtil;
import com.kdgc.framework.modules.utils.StringUtils;
import com.kdgc.framework.web.common.ResponseData;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FwTokenFilter
extends AuthenticatingFilter {
    private static final Logger log = LoggerFactory.getLogger(FwTokenFilter.class);
    private static final String LOGIN_TOKEN = "token";
    public static final String DEFAULT_USERNAME_PARAM = "username";
    public static final String DEFAULT_PASSWORD_PARAM = "password";
    private String authUrl;

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        boolean rememberMe = this.isRememberMe(request);
        if (this.isLoginSubmission(request, response)) {
            String username = WebUtils.getCleanParam((ServletRequest)request, (String)DEFAULT_USERNAME_PARAM);
            String password = WebUtils.getCleanParam((ServletRequest)request, (String)DEFAULT_PASSWORD_PARAM);
            return new FwAuthenticationToken(username, password, null, null, rememberMe, null, FwAuthenticationToken.ModeEnum.password);
        }
        String account = Cryptos.aesDecryptByKey(WebUtils.getCleanParam((ServletRequest)request, (String)LOGIN_TOKEN));
        if (StringUtils.isNotBlank((CharSequence)account)) {
            return new FwAuthenticationToken(account, null, null, null, rememberMe, null, FwAuthenticationToken.ModeEnum.agent);
        }
        return null;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            return this.executeLogin(request, response);
        }
        if (log.isTraceEnabled()) {
            log.trace("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]");
        }
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }

    protected void saveRequestAndRedirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        this.saveRequest(request);
        this.redirectToSSO(request, response);
    }

    protected boolean isLoginSubmission(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && WebUtils.toHttp((ServletRequest)request).getMethod().equalsIgnoreCase("POST");
    }

    private void redirectToSSO(ServletRequest request, ServletResponse response) throws IOException {
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.authUrl);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginSubmission(request, response)) {
            response.setCharacterEncoding("UTF-8");
            PrintWriter out = response.getWriter();
            out.println(JSONUtil.toJSon(ResponseData.SUCCESS_NO_DATA));
            out.flush();
            out.close();
        } else {
            this.issueSuccessRedirect(request, response);
        }
        return false;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }
}

