/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.modules.persistence;

import com.kdgc.framework.dao.key.UniqueTableApp;
import com.kdgc.framework.dao.key.impl.DefaultUniqueTableApp;
import com.kdgc.framework.dao.key.impl.MSSQLServerUniqueTableApp;
import com.kdgc.framework.dao.key.impl.MySqlUniqueTableApp;
import com.kdgc.framework.dao.key.impl.OracleUniqueTableApp;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.springframework.jdbc.core.JdbcTemplate;

public class Hibernates {
    public static void initLazyProperty(Object proxyedPropertyValue) {
        Hibernate.initialize((Object)proxyedPropertyValue);
    }

    public static String getDialect(DataSource dataSource) {
        String jdbcUrl = Hibernates.getJdbcUrlFromDataSource(dataSource);
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":h2:")) {
            return H2Dialect.class.getName();
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":mysql:")) {
            return MySQL5InnoDBDialect.class.getName();
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":oracle:")) {
            return Oracle10gDialect.class.getName();
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":postgresql:")) {
            return PostgreSQL82Dialect.class.getName();
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":sqlserver:")) {
            return SQLServer2008Dialect.class.getName();
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":db2:")) {
            return DB2Dialect.class.getName();
        }
        throw new IllegalArgumentException("Unknown Database of " + jdbcUrl);
    }

    public static UniqueTableApp getUniqueTableApp(JdbcTemplate jdbcTemplate) {
        String jdbcUrl = Hibernates.getJdbcUrlFromDataSource(jdbcTemplate.getDataSource());
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":h2:")) {
            return new DefaultUniqueTableApp(jdbcTemplate);
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":mysql:")) {
            return new MySqlUniqueTableApp(jdbcTemplate);
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":oracle:")) {
            return new OracleUniqueTableApp(jdbcTemplate);
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":postgresql:")) {
            return new DefaultUniqueTableApp(jdbcTemplate);
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":sqlserver:")) {
            return new MSSQLServerUniqueTableApp(jdbcTemplate);
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":db2:")) {
            return new DefaultUniqueTableApp(jdbcTemplate);
        }
        throw new IllegalArgumentException("Unknown Database of " + jdbcUrl);
    }

    private static String getJdbcUrlFromDataSource(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (connection == null) {
                throw new IllegalStateException("Connection returned by DataSource [" + dataSource + "] was null");
            }
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get database url", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

