/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.dao.key;

import com.kdgc.framework.dao.key.CacheValue;
import com.kdgc.framework.dao.key.UniqueTableApp;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SingleSequence {
    private final ReentrantLock lock = new ReentrantLock(false);
    protected long currVal = 0L;
    protected long maxVal = 0L;
    private final int cacheNum;
    private final UniqueTableApp app;
    private final TransactionTemplate transactionTemplate;

    public SingleSequence(int cacheNum, UniqueTableApp app, TransactionTemplate transactionTemplate) {
        this.cacheNum = cacheNum;
        this.app = app;
        this.transactionTemplate = transactionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextVal(String name) {
        try {
            this.lock.lock();
            if (this.currVal < this.maxVal) {
                long l;
                long l2 = l = this.currVal++;
                return l2;
            }
            CacheValue cache = this.getNewValFromDB(name);
            this.currVal = cache.getMinVal();
            this.maxVal = cache.getMaxVal();
            long l = this.currVal++;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private CacheValue getNewValFromDB(final String name) {
        this.transactionTemplate.setPropagationBehavior(3);
        return (CacheValue)this.transactionTemplate.execute(new TransactionCallback(){

            public CacheValue doInTransaction(TransactionStatus status) {
                return SingleSequence.this.app.getCacheValue(SingleSequence.this.cacheNum, name);
            }
        });
    }
}

