/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.core.support;

import com.kdgc.framework.core.support.MonitorAnnotation;
import com.kdgc.framework.modules.security.shiro.Principal;
import com.kdgc.framework.web.common.utils.AjaxUtil;
import com.kdgc.framework.web.entity.admin.FwOpMonitor;
import com.kdgc.framework.web.service.admin.IFwOpMonitorService;
import java.lang.reflect.Method;
import java.util.Calendar;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TraceInterceptor
implements MethodInterceptor {
    @Autowired(required=true)
    private HttpServletRequest request;
    @Resource(name="FwOpMonitorServiceImpl")
    private IFwOpMonitorService fwOpMonitorService;
    @Value(value="${monitor.log}")
    private boolean isMonitor;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Logger logger = LoggerFactory.getLogger(invocation.getClass());
        boolean result = true;
        long startTime = System.currentTimeMillis();
        try {
            logger.info("------------\u3010" + invocation.getMethod().getName() + "\u3011:BEGIN!--(cpi-framework)------------");
            logger.info("Class \u540d\u79f0\uff1a" + invocation.getMethod().getDeclaringClass().getName());
            Class<?>[] clazz = invocation.getMethod().getParameterTypes();
            for (int i = 0; i < clazz.length; ++i) {
                logger.info("arg[" + i + "]\u7c7b\u578b: " + clazz[i]);
            }
            Object i = invocation.proceed();
            return i;
        }
        catch (Exception e) {
            logger.error("Error happened in class {},in method {}", (Object)invocation.getMethod().getDeclaringClass().getName(), (Object)invocation.getMethod().getName());
            Object[] argus = invocation.getArguments();
            for (int i = 0; i < argus.length; ++i) {
                logger.error("arg[" + i + "]: " + argus[i]);
            }
            result = false;
            throw e;
        }
        finally {
            logger.info("------------\u3010" + invocation.getMethod().getName() + "\u3011:END!--(cpi-framework)------------");
            if (this.isMonitor) {
                this.afterInvoke(invocation.getMethod(), startTime, result);
            }
        }
    }

    public void afterInvoke(Method method, long startTime, boolean result) {
        MonitorAnnotation mAnnotation = method.getAnnotation(MonitorAnnotation.class);
        if (null != mAnnotation) {
            Principal principal;
            FwOpMonitor opLog = new FwOpMonitor();
            opLog.setOpActioname(mAnnotation.actionName());
            opLog.setOpContent(mAnnotation.methodDescr());
            opLog.setOpResult(result);
            opLog.setOpOptime(Calendar.getInstance().getTime());
            opLog.setOpTotaltime(opLog.getOpOptime().getTime() - startTime);
            opLog.setOpUrl(this.request.getRequestURI());
            opLog.setOpIp(AjaxUtil.getIpAddr(this.request));
            Subject subject = SecurityUtils.getSubject();
            if (subject != null && (principal = (Principal)subject.getPrincipal()) != null) {
                opLog.setOpUserid(principal.getId());
                opLog.setOpUsername(principal.getLoginName());
            }
            this.fwOpMonitorService.save(opLog);
        }
    }
}

