/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.core.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdgc.framework.core.support.TokenAnnotation;
import com.kdgc.framework.web.common.ResponseData;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TokenInterceptor
extends HandlerInterceptorAdapter {
    private static Logger logger = LoggerFactory.getLogger(TokenInterceptor.class);
    private static final String TOKEN_NAMESPACE = "kdgc.tokens";
    private static final String TOKEN_NAME_FIELD = "kdgc.token.name";
    protected final ObjectMapper mapper = new ObjectMapper();
    protected final Ehcache cache = CacheManager.create().getEhcache("kdgc.tokens");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Method method;
        TokenAnnotation annotation;
        response.addHeader("P3P", "CP=CAO PSA OUR");
        if (handler instanceof HandlerMethod && (annotation = (method = (handlerMethod = (HandlerMethod)handler).getMethod()).getAnnotation(TokenAnnotation.class)) != null) {
            boolean saveToken = annotation.saveToken();
            if (saveToken) {
                this.setToken(request);
                return true;
            }
            boolean removeToken = annotation.removeToken();
            if (removeToken) {
                return this.handleToken(request, response, handler);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleToken(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        TokenInterceptor tokenInterceptor = this;
        synchronized (tokenInterceptor) {
            if (!this.validToken(request)) {
                this.writeMessageUtf8(response, ResponseData.warn("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4!"));
                return false;
            }
        }
        return true;
    }

    protected void writeMessageUtf8(HttpServletResponse response, ResponseData responseData) throws IOException {
        try {
            String json = this.mapper.writeValueAsString((Object)responseData);
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().write(json);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String setToken(HttpServletRequest request) {
        return this.setToken(request, UUID.randomUUID().toString());
    }

    protected String setToken(HttpServletRequest request, String tokenName) {
        String token = UUID.randomUUID().toString();
        this.setCacheToken(request, tokenName, token);
        return token;
    }

    protected void setCacheToken(HttpServletRequest request, String tokenName, String token) {
        this.cache.put(new Element((Serializable)((Object)tokenName), (Serializable)((Object)token)));
        request.setAttribute(TOKEN_NAME_FIELD, (Object)tokenName);
        request.setAttribute(tokenName, (Object)token);
    }

    protected String getToken(HttpServletRequest request, String tokenName) {
        if (tokenName == null) {
            return null;
        }
        Map params = request.getParameterMap();
        String[] tokens = (String[])params.get(tokenName);
        if (tokens == null || tokens.length < 1) {
            logger.warn("Could not find token mapped to token name " + tokenName);
            return null;
        }
        String token = tokens[0];
        return token;
    }

    protected String getTokenName(HttpServletRequest request) {
        Map params = request.getParameterMap();
        if (!params.containsKey(TOKEN_NAME_FIELD)) {
            logger.warn("Could not find token name in params.");
            return null;
        }
        String[] tokenNames = (String[])params.get(TOKEN_NAME_FIELD);
        if (tokenNames == null || tokenNames.length < 1) {
            logger.warn("Got a null or empty token name.");
            return null;
        }
        String tokenName = tokenNames[0];
        return tokenName;
    }

    protected boolean validToken(HttpServletRequest request) {
        String tokenName = this.getTokenName(request);
        if (tokenName == null) {
            logger.debug("no token name found -> Invalid token ");
            return false;
        }
        String token = this.getToken(request, tokenName);
        if (token == null) {
            return false;
        }
        Element cacheElement = this.cache.get((Serializable)((Object)tokenName));
        String cacheToken = null;
        if (cacheElement != null) {
            cacheToken = (String)cacheElement.getObjectValue();
        }
        if (!token.equals(cacheToken)) {
            logger.warn("xxx.internal.invalid.token Form token " + token + " does not match the session token " + cacheToken + ".");
            return false;
        }
        this.cache.remove((Serializable)((Object)tokenName));
        return true;
    }
}

