/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.framework.core.support;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ProfileApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger _logger = LoggerFactory.getLogger(ProfileApplicationContextInitializer.class);
    public static String casProfile;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        try {
            ClassPathResource resource = new ClassPathResource("profile.properties");
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
            String profile = properties.getProperty("spring.profiles.active");
            casProfile = properties.getProperty("security.profiles.active");
            if (profile == null) {
                profile = "development";
            }
            if (casProfile == null) {
                casProfile = "nocas";
            }
            applicationContext.getEnvironment().setActiveProfiles(new String[]{profile, casProfile});
            _logger.info("spring profile {}", (Object)profile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

