package com.kdgc.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.dao.admin.IFwStationDao;
import com.kdgc.framework.web.entity.admin.FwStation;
import com.kdgc.framework.web.service.admin.IFwStationService;

/**
 * 功能 ：岗位管理Service层实现定义
 * @author zwwang  2015-6-3 上午11:47:05
 */
@Transactional
@Service("FwStationServiceImpl")
public class FwStationServiceImpl extends BaseServiceImpl<FwStation, Long> implements IFwStationService {
	
	@Resource(name = "FwStationDaoImpl")
	private IFwStationDao fwStationDao;

	@Resource(name = "FwStationDaoImpl")
	public void setBaseDao(IFwStationDao fwStationDao) {
		super.setBaseDao(fwStationDao);
	}
	
	@Transactional(readOnly = true)
	@Override
	public List<FwStation> findStationList(Long orgId) {
		List<Filter> filters = new ArrayList<Filter>();
		if (orgId!=null) {
			filters.add(Filter.eq("orgId", orgId));
		}
		filters.add(Filter.eq("status", StatusEnum.Y));
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("orgId"));
		orders.add(Order.asc("orderNo"));
		return fwStationDao.findList(null, null, filters, orders);
	}

	
	
	
	
	
	@Override
	public void deleteStation(List<Long> ids) {
		fwStationDao.deleteStation(ids);
	}

	@Override
	@Transactional(readOnly=true)
	public List<FwStation> findChildStations(Long parentId,String orgName) {
		List<Filter> filters=new ArrayList<Filter>();
		List<Order> orders=new ArrayList<Order>();
		filters.add(Filter.eq("pId", parentId));
		filters.add(Filter.eq("status", StatusEnum.Y));
		if(StringUtils.isNotBlank(orgName)){
		   filters.add(Filter.like("orgName","%"+ orgName+"%"));
		}
		orders.add(Order.asc("orderNo"));
		List<FwStation> fwStations= super.findList(null, filters, orders);
		return fwStations;
	}
}
