package com.kdgc.framework.web.service.admin.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.dao.support.Filter.Operator;
import com.kdgc.framework.dao.support.Order.Direction;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.dao.admin.IFwPendingMessageDao;
import com.kdgc.framework.web.entity.admin.FwPendingDetails;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;
import com.kdgc.framework.web.entity.admin.FwPendingMessage.MessageType;
import com.kdgc.framework.web.service.admin.IFwPendingMessageService;


@Transactional
@Service("FwPendingMessageServiceImpl")
public class FwPendingMessageServiceImpl extends BaseServiceImpl<FwPendingMessage, Long> implements IFwPendingMessageService {

	@Resource(name="FwPendingMessageDaoImpl")
	private IFwPendingMessageDao fwPendingMessageDao;
	
	@Resource(name = "FwPendingMessageDaoImpl")
	public void setBaseDao(IFwPendingMessageDao fwPendingMessageDao) {
		super.setBaseDao(fwPendingMessageDao);
	}

	@Override
	public void updateMsgStatus(Long processInstId,Long userId,boolean isColse) {
		List<Filter> filters = new ArrayList<Filter>();
		List<Order> orderList = new ArrayList<Order>();
		Order order=new Order("createDate", Direction.desc);
		orderList.add(order);
		filters.add(new Filter("processInstId", Operator.eq, processInstId));		
		List<FwPendingMessage> fwPendingMessages= fwPendingMessageDao.findList(null, null, filters, orderList);
		if(fwPendingMessages!=null && fwPendingMessages.size()>0){
			FwPendingMessage fwPendingMessage=fwPendingMessages.get(0);
			boolean isAllDeal=true;
			for(Iterator<FwPendingDetails> it=fwPendingMessage.getFwPendingDetails().iterator();it.hasNext();){
				FwPendingDetails fwPendingDetail=it.next();
				if(userId.equals(fwPendingDetail.getReceiverId()) && !fwPendingDetail.getIsDeal()){
					fwPendingDetail.setIsDeal(true);
					fwPendingDetail.setRead(true);
					fwPendingDetail.setReadTime(new Date());
				}else{
					isAllDeal=isAllDeal&&fwPendingDetail.getIsDeal();
				}
			}
			if(isAllDeal||isColse){//明细全部办完时或者工作项完成时改变主表状态
				fwPendingMessage.setIsdeal(true);
			}
			super.update(fwPendingMessage);
		}
		
	}
	@Override
	@Transactional(readOnly = true)
	public List<FwPendingMessage> queryUserPendingMsg(Long userId) {		
		return fwPendingMessageDao.queryUserPendingMsg(userId);
	}

	@Override
	@Transactional(readOnly = true)
	public List<FwPendingMessage> findFwMessageByBusiness(Long business) {
		return fwPendingMessageDao.findFwMessageByBusiness(business);
	}

	@Override
	public void updateQueryFwMessageByBusiness(Long msgId,
			Long userId) {
		
		//更具消息表主键查询记录
		FwPendingMessage fwPendingMessage= fwPendingMessageDao.find(msgId);
		
		if(fwPendingMessage!=null){
			
			//若是消息：已办，已读 ；若是待办：已读
			
			for(Iterator<FwPendingDetails> it=fwPendingMessage.getFwPendingDetails().iterator();it.hasNext();){
				FwPendingDetails fwPendingDetail=it.next();
				if(userId.equals(fwPendingDetail.getReceiverId())){
					
					if(MessageType.message.equals(fwPendingMessage.getBusiType())){
						fwPendingDetail.setIsDeal(true);
						fwPendingDetail.setRead(true);
					}else{
						fwPendingDetail.setRead(true);
					}
					
					fwPendingDetail.setReadTime(new Date());
				}
			}
			if(MessageType.message.equals(fwPendingMessage.getBusiType())){
			     fwPendingMessage.setIsdeal(true);
			}
			super.update(fwPendingMessage);
		}
	}

	@Override
	public void updateMsgStatus(Long business, Long processInstId,Long recieveId,boolean isColse) {
		List<Filter> filters = new ArrayList<Filter>();
		List<Order> orderList = new ArrayList<Order>();
		Order order=new Order("createDate", Direction.desc);
		orderList.add(order);
		filters.add(new Filter("businessId", Operator.eq, business));	
		filters.add(new Filter("processInstId", Operator.eq, processInstId));
		filters.add(new Filter("busiType", Operator.eq, MessageType.pending));
		filters.add(new Filter("isdeal", Operator.eq, false));
		List<FwPendingMessage> fwPendingMessages= fwPendingMessageDao.findList(null, null, filters, orderList);
		if(fwPendingMessages!=null && fwPendingMessages.size()>0){
			FwPendingMessage fwPendingMessage=fwPendingMessages.get(0);
			boolean isAllDeal=true;
			for(Iterator<FwPendingDetails> it=fwPendingMessage.getFwPendingDetails().iterator();it.hasNext();){
				FwPendingDetails fwPendingDetail=it.next();
				if(recieveId.equals(fwPendingDetail.getReceiverId()) && !fwPendingDetail.getIsDeal()){
					fwPendingDetail.setIsDeal(true);
					fwPendingDetail.setRead(true);
					fwPendingDetail.setReadTime(new Date());
				}else{
					isAllDeal=isAllDeal&&fwPendingDetail.getIsDeal();
				}
			}
			if(isAllDeal||isColse){//明细全部办完时或者要求关闭待办
				fwPendingMessage.setIsdeal(true);
			}
			super.update(fwPendingMessage);
		}
	}

	@Override
	@Transactional(readOnly = true)
	public List<FwPendingMessage> queryUserAlreadyPendingMsg(Long id) throws ParseException {
		return fwPendingMessageDao.queryUserAlreadyPendingMsg(id);
	}
	
	
}
