package com.kdgc.framework.web.service.admin.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.kdgc.framework.core.cache.CacheNames;
import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.common.CommonAttributes;
import com.kdgc.framework.web.dao.admin.IFwMenuDao;
import com.kdgc.framework.web.entity.admin.FwMenu;
import com.kdgc.framework.web.service.admin.IFwMenuService;

@Transactional
@Service("FwMenuServiceImpl")
public class FwMenuServiceImpl extends BaseServiceImpl<FwMenu, Long> implements	IFwMenuService {

	@Resource(name="FwMenuDaoImpl")
	private IFwMenuDao fwMenuDao;
	
	@Resource(name="FwMenuDaoImpl")
	public void setBaseDao(IFwMenuDao fwMenuDao) {
		super.setBaseDao(fwMenuDao);
	}
	
	@Override
	@Transactional(readOnly=true)
	public FwMenu findMenu(Long menuId) {
		return fwMenuDao.find(menuId);
	}

	@Override
	@Transactional(readOnly=true)
	public List<FwMenu> findChildMenus(Long pMenuId) {
		List<Filter> filters=new ArrayList<Filter>();
		filters.add(Filter.eq("parentId", pMenuId));
		filters.add(Filter.eq("isDisplay", StatusEnum.Y));
		List<FwMenu> fwMenus= super.findList(null, filters, null);
		if(fwMenus!=null){
			Subject curentUser=SecurityUtils.getSubject();
			Iterator<FwMenu> it=fwMenus.iterator();
			while(it.hasNext()){
				FwMenu fwMenu=it.next();
				if(!curentUser.isPermitted(MessageFormat.format(CommonAttributes.MENU_PERMISSON_INSTANCEID,fwMenu.getId()))){
					it.remove();
				}
			}
			return fwMenus;
		}
		return null;
	}

	@Override
	@Transactional(readOnly=true)
	@Cacheable(value=CacheNames.RESOURCE_CACHE_NAME)
	public List<FwMenu> findCacheAllMenus() {
		List<Filter> filters=new ArrayList<Filter>();
		filters.add(Filter.eq("isDisplay", StatusEnum.Y));
		return super.findList(null, filters, null);		
	}
}
