package com.kdgc.framework.web.service.admin.impl;

import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import com.kdgc.framework.web.service.admin.IFwMailService;

/**
 * Service - 邮件
 * 
 * @author Bridgebai
 */
@Service("FwMailServiceImpl")
public class FwMailServiceImpl implements IFwMailService {
	
	@Resource(name = "javaMailSender")
	private JavaMailSenderImpl javaMailSender;
	@Resource(name = "taskExecutor")
	private TaskExecutor taskExecutor;	
	
	@Value("${mail.from}")
	private String smtpFromMail;
	/**
	 * 添加邮件发送任务
	 * 
	 * @param mimeMessage
	 *            MimeMessage
	 */
	private void addSendTask(final MimeMessage mimeMessage) {
		try {
			taskExecutor.execute(new Runnable() {
				public void run() {
					javaMailSender.send(mimeMessage);
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public void send(String toMail, String text,String subject,boolean async) {
		Assert.hasText(toMail);
		Assert.hasText(subject);
		try {
			
			MimeMessage mimeMessage = javaMailSender.createMimeMessage();
			MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, false, "utf-8");
			mimeMessageHelper.setFrom(" <" + smtpFromMail + ">");
			mimeMessageHelper.setSubject(subject);
			mimeMessageHelper.setTo(toMail);
			mimeMessageHelper.setText(text, true);
				if (async) {
			    	addSendTask(mimeMessage);
			    } else {
			    	javaMailSender.send(mimeMessage);
			    }
		} catch (MessagingException e) {
			e.printStackTrace();
		}
	}
	
}