package com.kdgc.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.kdgc.framework.core.cache.CacheNames;
import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.dao.support.Filter.Operator;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.dao.admin.IFwDictionaryTypeDao;
import com.kdgc.framework.web.entity.admin.FwDictionary;
import com.kdgc.framework.web.entity.admin.FwDictionaryType;
import com.kdgc.framework.web.service.admin.IFwDictionaryTypeService;

/**
 * 数据字典类型服务
 * 
 * @author BridgeBai
 * 
 */
@Transactional
@Service("FwDictionaryTypeServiceImpl")
public class FwDictionaryTypeServiceImpl extends BaseServiceImpl<FwDictionaryType, Long> implements IFwDictionaryTypeService {

	@Resource(name="FwDictionaryTypeDaoImpl")
	private IFwDictionaryTypeDao dictionaryTypeDao;
    
	
	@Resource(name="FwDictionaryTypeDaoImpl")
	public void setBaseDao(IFwDictionaryTypeDao dictionaryTypeDao) {
		super.setBaseDao(dictionaryTypeDao);
	}

	@Transactional(readOnly = true)
	@Override
	public Pagination<FwDictionaryType> findDictionaryTypeList(String typeName, int start, int limit) {
		List<Filter> filterList = new ArrayList<Filter>();
		Filter filterName;
		if (!StringUtils.isEmpty(typeName)) {
			filterName = new Filter("dicTypeName", Operator.like, "%" + typeName + "%");
			filterList.add(filterName);
		}
		Pageable pageable = new Pageable();
		pageable.setFilters(filterList);
		pageable.setPageSize(limit);
		pageable.setPageNumber((start + limit)/limit);
		return super.findPage(pageable);
	}

	@Transactional(readOnly = true)
	@Override
	public Pagination<FwDictionaryType> findDictionaryTypeById(Long id) {
		FwDictionaryType fwDictionaryType = super.find(id);
		List<FwDictionaryType> list = new ArrayList<FwDictionaryType>();
		list.add(fwDictionaryType);
		return new Pagination<FwDictionaryType>(list, list.size(), null);
	}

	@Override
	@CacheEvict(value=CacheNames.DICT_CACHE_NAME,allEntries=true)
	public void addDictionaryType(FwDictionaryType dictionaryType) {
		super.save(dictionaryType);
	}

	@Override
	@CacheEvict(value=CacheNames.DICT_CACHE_NAME,allEntries=true)
	public void modifyDictionaryType(FwDictionaryType entity) {
		super.update(entity);
	}
	
	@Override
	@CacheEvict(value=CacheNames.DICT_CACHE_NAME,allEntries=true)
	public void addDictionary(FwDictionary dictionary, Long dicTypeIdDetail) {
		FwDictionaryType fwDictionaryType = super.find(dicTypeIdDetail);
		fwDictionaryType.addFwDictionary(dictionary);
		super.update(fwDictionaryType);
	}

	@Override
	@Transactional(readOnly = true)
	public Pagination<FwDictionaryType> findDicTypeList(String dicTypeName, Pageable pageable) {
		return dictionaryTypeDao.findDicTypeList(dicTypeName, pageable);
	}
}
