package com.kdgc.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.kdgc.framework.core.cache.CacheNames;
import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.dao.support.Filter.Operator;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.common.CombVO;
import com.kdgc.framework.web.dao.admin.IFwDictionaryDao;
import com.kdgc.framework.web.dao.admin.IFwDictionaryTypeDao;
import com.kdgc.framework.web.entity.admin.FwDictionary;
import com.kdgc.framework.web.entity.admin.FwDictionaryType;
import com.kdgc.framework.web.service.admin.IFwDictionaryService;

/**
 * 数据字典服务
 * @author BridgeBai
 *
 */
@Transactional
@Service("FwDictionaryServiceImpl")
public class FwDictionaryServiceImpl extends BaseServiceImpl<FwDictionary, Long> implements IFwDictionaryService {
	
	@Resource(name="FwDictionaryDaoImpl")
	private IFwDictionaryDao dictionaryDao;
    
	@Resource(name="FwDictionaryTypeDaoImpl")
	private IFwDictionaryTypeDao dictionaryTypeDao;
	
	@Resource(name="FwDictionaryDaoImpl")
	public void setBaseDao(IFwDictionaryDao dictionaryDao) {
		super.setBaseDao(dictionaryDao);
	}
	
	@Override
	@Transactional(readOnly=true)
	@Cacheable(value=CacheNames.DICT_CACHE_NAME,key="#root.methodName+#dictTypeCode")
	public Set<FwDictionary> findDictionarys(String dictTypeCode) {
		FwDictionaryType fwDictionaryType =dictionaryTypeDao.findDictionarys(dictTypeCode);
		if(fwDictionaryType!=null){
			return fwDictionaryType.getFwDictionarys();
		}
		return null;
	}

	
	@Override
	@Transactional(readOnly=true)
	@Cacheable(value=CacheNames.DICT_CACHE_NAME)
	public List<CombVO> findDictCombs(String dictTypeCode) {
		List<CombVO> cmbList = new ArrayList<CombVO>();
		FwDictionaryType fwDictionaryType =dictionaryTypeDao.findDictionarys(dictTypeCode);
		for (FwDictionary dic : fwDictionaryType.getFwDictionarys()) {
			CombVO cmb = new CombVO();
			cmb.setCode(dic.getId().toString());
			cmb.setValue(dic.getDicValue());
			cmbList.add(cmb);
		}
		return cmbList;
	}

	@Override
	@Transactional(readOnly=true)
	public Map<String,String> findDictMaps(String dictTypeCode) {
		Map<String,String> dicMap = new HashMap<String,String>();
		FwDictionaryType fwDictionaryType =dictionaryTypeDao.findDictionarys(dictTypeCode);
		for (FwDictionary dic : fwDictionaryType.getFwDictionarys()) {
			dicMap.put(dic.getId().toString(), dic.getDicValue());
		}
		return dicMap;
	}
	
	@Override
	@Transactional(readOnly=true)
	public Map<String,String> findDictCodeMaps(String dictTypeCode) {
		Map<String,String> dicMap = new HashMap<String,String>();
		FwDictionaryType fwDictionaryType =dictionaryTypeDao.findDictionarys(dictTypeCode);
		for (FwDictionary dic : fwDictionaryType.getFwDictionarys()) {
			dicMap.put(dic.getId().toString(), dic.getDicCode());
		}
		return dicMap;
	}
	
	@Override
	@Transactional(readOnly=true)
	public Pagination<FwDictionary> findDictionaryList(Long dicTypeId, int start, int limit) {
		List<Filter> filterList = new ArrayList<Filter>();
		Filter filterTypeId;
		if (dicTypeId != null) {
			filterTypeId = new Filter("dicTypeId", Operator.eq, dicTypeId);
			filterList.add(filterTypeId);
		}
		Pageable pageable = new Pageable();
		pageable.setFilters(filterList);
		pageable.setPageSize(limit);
		pageable.setPageNumber((start + limit)/limit);
		return super.findPage(pageable);
	}

	@Override
	@Transactional(readOnly=true)
	public Pagination<FwDictionary> findDictionaryById(Long id) {
		List<FwDictionary> list = new ArrayList<FwDictionary>();
		FwDictionary fwDictionary = super.find(id);
		list.add(fwDictionary);
		return new Pagination<FwDictionary>(list, list.size(), null);
	}

	@Override
	@CacheEvict(value=CacheNames.DICT_CACHE_NAME,allEntries=true)
	public void updateDictionary(Long dicTypeIdDetail, FwDictionary entity) {
		FwDictionaryType fwDictionaryType = new FwDictionaryType();
		fwDictionaryType.setId(dicTypeIdDetail);
		entity.setDicTypeId(fwDictionaryType);
		super.update(entity);
	}

	@Override
	@CacheEvict(value=CacheNames.DICT_CACHE_NAME,allEntries=true)
	public void removeDictionary(Long[] ids) {
		dictionaryDao.removeDictionary(ids);
	}

	@Override
	@Transactional(readOnly=true)
	public Pagination<FwDictionary> findDicList(Long dicTypeId, Pageable pageable) {
		return dictionaryDao.findDicList(dicTypeId, pageable);
	}
}
