/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.kdgc.framework.web.service.admin;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;

import com.kdgc.framework.modules.security.shiro.FwAuthenticationToken;
import com.kdgc.framework.modules.security.shiro.FwCredentialsMatcher;
import com.kdgc.framework.modules.security.shiro.Principal;
import com.kdgc.framework.modules.security.utils.Cryptos;
import com.kdgc.framework.web.dao.admin.IFwOrgDao;
import com.kdgc.framework.web.dao.admin.IFwUserDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwPermissions;
import com.kdgc.framework.web.entity.admin.FwRoles;
import com.kdgc.framework.web.entity.admin.FwUser;
import com.kdgc.framework.web.entity.admin.FwOrg.orgEnum;

public class ShiroDbRealm extends AuthorizingRealm {
	
	@Resource(name = "FwUserDaoImpl")
	private IFwUserDao fwUsernDao;
	
	@Resource(name = "FwOrgDaoImpl")
	private IFwOrgDao fwOrgDao;
	/**
	 * 认证回调函数,登录时调用.
	 */
	@Override
	protected AuthenticationInfo doGetAuthenticationInfo(
			AuthenticationToken authcToken) throws AuthenticationException {
		FwAuthenticationToken token =(FwAuthenticationToken)authcToken;
		String username = token.getUsername();
		//Long companyId= token.getCompanyId();
		FwUser user = fwUsernDao.findByLoginName(username);
		if (user != null) {
			Long userOrgId;
			if(orgEnum.company.equals(user.getOrgId().getOrgType())){
			   userOrgId=user.getOrgId().getId();
			}else{
			   userOrgId=findUserOrgId(user.getOrgId().getId());
			}
			return new SimpleAuthenticationInfo(new Principal(user.getId(),user.getLogincode(),user.getUsername(),user.getOrgId().getId() ,userOrgId), user.getPassword(),
					ByteSource.Util.bytes(Cryptos.HASH_SALT.getBytes()),
					getName());
		}
		throw new UnknownAccountException();
	}

	/**
	 * 授权查询回调函数, 进行鉴权但缓存中无用户的授权信息时调用.
	 */
	@Override
	protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
		Principal principal = (Principal) principals.getPrimaryPrincipal();		
		if (principal !=null) {
		    SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
		    FwUser fwUser = fwUsernDao.find(principal.getId());	
			if(fwUser!=null){
				for (FwRoles fwRole : fwUser.getFwRoles()) {
					info.addRole(String.valueOf(fwRole.getId()));
				}
				info.addStringPermissions(this.getPermissonCode(fwUser));
			}
			return info;
		}
		return null;
	}

	/**
	 * 设定Password校验的Hash算法与迭代次数.
	 */
	@PostConstruct
	public void initCredentialsMatcher() {
		FwCredentialsMatcher matcher = new FwCredentialsMatcher(Cryptos.HASH_ALGORITHM);
		matcher.setHashIterations(Cryptos.HASH_INTERATIONS);
		setCredentialsMatcher(matcher);
	}
	
	/**
	 * 获取用户权限
	 * @param fwUser
	 * @return
	 */
	private Set<String> getPermissonCode(FwUser fwUser){
		Set<String> fwPermissonCode=new HashSet<String>();
		if (fwUser != null) {
			Set<FwPermissions> fwPermissons = new HashSet<FwPermissions>();
			/**人员自己拥有的权限*/
			fwPermissons.addAll(fwUser.getFwPermissions());
			/**人员角色拥有的权限*/
			for (FwRoles role : fwUser.getFwRoles()) {
				fwPermissons.addAll(role.getFwPermissions());
			}
			/**人员岗位拥有的权限*/
		    fwPermissons.addAll(fwUser.getStId().getFwPermissions());
		    for (FwPermissions fwPermisson : fwPermissons) {
		    	fwPermissonCode.add(fwPermisson.getPermissionCode());
			}
		}
		return fwPermissonCode;
	}
	 /**
     * ShiroSession设置
     * 
     * @see 使用时直接用HttpSession.getAttribute(key)就可以取到
     */
    private void setSession(Object key, Object value) {
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser) {
            Session session = currentUser.getSession();
            if (null != session) {
                session.setAttribute(key, value);
            }
        }
    }
    
    private Long findUserOrgId(Long orgId){
        FwOrg fwOrg=fwOrgDao.findParentFwOrg(orgId);
    	while(fwOrg!=null && !orgEnum.company.equals(fwOrg.getOrgType())){
			fwOrg=fwOrgDao.findParentFwOrg(fwOrg.getId());
		}
    	return (fwOrg!=null)?fwOrg.getId():null;
    }
}
