package com.kdgc.framework.web.service.admin;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.modules.security.shiro.Principal;
import com.kdgc.framework.service.jpa.IBaseService;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwRoles;
import com.kdgc.framework.web.entity.admin.FwUser;
import com.kdgc.framework.web.entity.admin.FwRoles.RoleEnum;

public interface IFwUserService extends IBaseService<FwUser, Long>{

	/**
	 * 判断用户名是否存在
	 * 
	 * @param loginName
	 *            用户名(忽略大小写)
	 * @return 用户名是否存在
	 */
	boolean loginNameExists(String loginName);
	/**
	 * 根据用户名查找用户
	 * 
	 * @param loginName
	 *            用户名(忽略大小写)
	 * @return 管理员，若不存在则返回null
	 */
	FwUser findByLoginName(String loginName);
	
	/**
	 * 功能：根据单位编码查询指定单位的人员
	 * @author BridgeBai
	 * @date   2016年6月6日下午8:13:24
	 * @param orgCodes
	 * @return
	 */
	List<FwUser> findUsersByDeptCode(List<String> orgCodes);
	/**
	 * 根据ID对象查找用户角色
	 * @param Id ID
	 * @return 角色,若不存在则返回null
	 */
	Set<FwRoles> findRoles(Long id);
	/**
	 * 获取所有用户
	 * @return Map<人员ID,FwUser>(缓存)
	 */
	Map<Long,FwUser> findAllUser();
	/**
	 * 判断用户是否登录
	 * 
	 * @return 用户是否登录
	 */
	boolean isAuthenticated();
	
	/**
	 * 是否是超级管理员/管理员
	 * @return
	 */
	boolean isSuperAdmin();
	/**
	 * 获取当前用户
	 * 
	 * @return 若不存在则返回null
	 */
	FwUser getCurrent();

	/**
	 * 获取当前登录用户票据信息
	 * 
	 * @return 当前登录用户票据,若不存在则返回null
	 */
	Principal getCurrentPrincipal();
	/**
	 * 功能：查询所指定的单位内具有指定岗位编码的人员
	 * @author BridgeBai
	 * @date   2016年4月19日下午6:47:24
	 * @param fwOrgs 单位
	 * @param stCode 岗位编码
	 * @return
	 */
	public List<FwUser> findUsersByDeptAndStCode(List<FwOrg> fwOrgs,String stCode);
	/**获取组织机构下用户信息 */
	List<FwUser> findOrgUsers(FwOrg fwOrg);
	/**更新用户信息 */
	FwUser updateFwUser(FwUser fwUser);
	/**删除用户信息 */
	void deleteFwUser(FwUser fwUser);
	/**
	 * 功能 : 查询未被选为项目组成员的人员
	 * 开发：zwwang 2015-6-13 上午11:00:40
	 * @param memberIds 已被选为项目组成员人员的id
	 * @param queryName
	 * @param start
	 * @param limit
	 * @return
	 */
	public Pagination<FwUser> findWaitMember(List<Long> memberIds, String queryName, Integer start, Integer limit);
	/**
	 * 功能 : 删除用户
	 * 开发：zwwang 2015-6-16 下午2:43:28
	 * @param userIds 被删除数据的id
	 */
	public void deleteUser(List<Long> userIds);
	
	/**
	 * 功能 : 查询人员部门弹出框
	 * 开发：wwzhang 2015-11-9
	
	 * @param deptId      部门id
	 * @param userName    用户姓名
	 * @param page        起始页
	 * @param rows        行数
	 * @return
	 */
	public List<FwUser> findUserAndOrg(String deptId,String userName,int page,int rows);
	
	/**
	 * 
	 * 功能 :查询数据个总数
	
	 * 开发：wwzhang 2015-11-9
	
	 * @param deptId      部门id
	 * @param userName    用户姓名
	 * @return
	 */
	public Long getCount(String deptId, String userName);
	
	/**
	 * 功能：根据用户姓名模糊查询用户信息
	 * @author BridgeBai
	 * @date   2015年11月16日下午4:11:26
	 * @param userName 用户姓名
	 * @param pageable 分页对象
	 * @return
	 */
	public Pagination<FwUser> findLikeUserName(String userName,Pageable pageable);
	/**
	 * 功能：根据角色类别查询人员信息
	 * @author BridgeBai
	 * @date   2015年11月23日下午3:58:27
	 * @param roleEnum 角色类别
	 * @return
	 */
	public List<FwUser> findUserByRoleType(RoleEnum roleEnum);
	/**
	 * 功能：根据权限编码查询对应的人员信息(包括角色对应的权限人员，岗位对应的权限人员)
	 * @author BridgeBai
	 * @date   2015年11月24日下午8:20:17
	 * @param permissionCode 权限编码
	 * @return
	 */
	public List<FwUser> findUserByPermisson(String permissionCode);
	/**
	 * 
	 * @Title: findUserList 
	 * @author: hwzhu   
	 * @date: 2016年3月11日 上午11:15:43
	 * @Description: 通过组织Id查询该组织下所有用户，（其中组织树根节点查询 所有）
	 * @param orgId
	 * @param pageable
	 * @return
	 * @return: Pagination<FwUser>
	 */
	public Pagination<FwUser> findUserList(Long orgId,String userNameOrCode,Pageable pageable);
	
	/**
	 * 
	 * 功能 :查询有待办的用户
	
	 * 开发：wwzhang 2016-6-17
	
	 * @return
	 */
	public List<FwUser> findNotDealMessage();
}
