package com.kdgc.framework.web.service.admin;

import java.util.List;

import com.kdgc.framework.service.jpa.IBaseService;
import com.kdgc.framework.web.entity.admin.FwPermissions;

/**
 * 功能 ：权限管理Service层接口定义
 * @author zwwang  2015-6-4 上午9:58:36
 */
public interface IFwPermissionsService extends IBaseService<FwPermissions, Long> {
	
	/**
	 * 功能 : 查询权限数据
	 * 开发：zwwang 2015-6-6 下午2:59:11
	 * @param permissionName 权限名称
	 * @param permissionType 权限类型
	 * @return
	 */
	public List<FwPermissions> findPermissionsList(String permissionName, String permissionType);
	
	/**
	 * 功能 : 根据权限id删除权限记录
	 * 开发：zwwang 2015-6-6 下午3:21:32
	 * @param ids 权限记录的id
	 */
	public void deletePermissions(List<Long> ids);
}
