package com.kdgc.framework.web.service.admin;

import java.text.ParseException;
import java.util.List;

import com.kdgc.framework.service.jpa.IBaseService;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;

public interface IFwPendingMessageService extends IBaseService<FwPendingMessage, Long> {

	/**
	 * 查询当前人员的待办消息
	 * @param userId
	 * @return
	 */
	public List<FwPendingMessage> queryUserPendingMsg(Long userId);
	/**
	 * 更新消息的处理状态为已处理
	 * @param processInstId 流程实例ID
	 * @param userId        人员ID
	 * @param isColse   是否关闭待办
	 */
	public void updateMsgStatus(Long processInstId,Long userId,boolean isColse);
	
	/**
	 * 根据业务表的id查询消息信息
	 * @param business  业务表id
	 */
	public List<FwPendingMessage> findFwMessageByBusiness(Long business);
	
	/**
	 * 根据消息表的id查询和用户id处理消息状态为已处理
	 * @param business  业务表id
	 */
	public void updateQueryFwMessageByBusiness(Long msgId,Long userId);
	
	/**
	 * 
	 * 功能 :根据业务表主键和用户id处理消息
	
	 * 开发：wwzhang 2016-5-7
	
	 * @param business 业务主键
	 * @param processInstId 流程实例或业务类型
	 * @param recieveId   接收人
	 * @param isColse   是否关闭待办
	 */
	public void updateMsgStatus(Long business, Long processInstId,Long recieveId,boolean isColse);
	
	/**
	 * 
	 * 功能 :我的已办
	
	 * 开发：wwzhang 2016-6-27
	
	 * @param id 用户id
	 * @return
	 * @throws ParseException 
	 */
	public List<FwPendingMessage> queryUserAlreadyPendingMsg(Long id) throws ParseException;
	
}
