package com.kdgc.framework.web.service.admin;

import java.util.List;

import com.kdgc.framework.service.jpa.IBaseService;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwUser;

public interface IFwOrgService extends IBaseService<FwOrg, Long>{

	/**
	 * 获取父组织机构下的所有子组织
	 * @param parentId
	 * @param orgName
	 * @return
	 */
	List<FwOrg> findChildOrgs(Long parentId,String orgName);
	
	/**
	 * 获取分管的部门信息
	 * @param fwUser
	 * @return
	 */
	List<FwOrg> findChargeOrgs(FwUser fwUser);
	
	
	/** 
	 * 功能 :查询当前组织机构和子组织的信息
	 * 开发：shywang 2015-12-1	
	 * @param deptId
	 * @return
	 */
	public FwOrg findFwOrgs(Long deptId);
}
