package com.kdgc.framework.web.service.admin;

import java.util.List;

import com.kdgc.framework.service.jpa.IBaseService;
import com.kdgc.framework.web.entity.admin.FwMenu;

/**
 * 系统菜单Dao层接口定义
 * 
 * @author BridgeBai
 */
public interface IFwMenuService extends IBaseService<FwMenu, Long> {

	/**
	 * 查询菜单信息
	 * @param menuId 菜单ID
	 * @return 菜单信息
	 */
	public FwMenu findMenu(Long menuId);
	
	/**
	 * 查询当前人员的子菜单信息
	 * @param pMenuId 符菜单ID
	 * @return 菜单信息
	 */
	public List<FwMenu> findChildMenus(Long pMenuId);

    /**
     * 功能：加载全部菜单数据并缓存
     * @author BridgeBai
     * @date   2016年4月21日上午10:02:39
     * @return
     */
	public List<FwMenu> findCacheAllMenus();
}
