package com.kdgc.framework.web.entity.admin;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kdgc.framework.dao.model.SortEntity;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.web.entity.admin.FwOrg.orgEnum;

/**
 * 用户表
 * 
 * @author BridgeBai
 */
@Entity
@Table(name = "FW_USER")
public class FwUser extends SortEntity {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	/**人员性别*/
	public enum sexEnum{
		/** 男性*/
		M,
		/** 女性 */
		F
	}
	/**数据来源*/
	public enum SourceEnum{
		/** 系统内*/
		in,
		/** 系统外 */
		outside
	}
	/**登录账号*/
	private String logincode;
	/**人员姓名*/
	private String username;
	/**组织*/
	private FwOrg orgId;
	/**岗位*/
	private FwStation stId;
	/**密码*/
	private String password;
	/**电话*/
	private String telephone;
	/**邮箱*/
	private String email;
	/**人员性别*/
	private sexEnum sex;
	/**身份证号*/
	private String identification;
	/**出生日期*/
	private Date birthday;
	/**数据来源*/
	private SourceEnum source=SourceEnum.in;
	/**状态*/
	private StatusEnum status;
	/**备注*/
	private String memo;
	/** 角色 */
	private Set<FwRoles> fwRoles = new HashSet<FwRoles>();
	/**权限  */
	private Set<FwPermissions> fwPermissions = new HashSet<FwPermissions>();

    public FwUser(){
		
	}
    public FwUser(Long id){
		super.setId(id);
	}
    
	@Temporal(TemporalType.DATE)
	public Date getBirthday() {
		return this.birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getIdentification() {
		return this.identification;
	}

	public void setIdentification(String identification) {
		this.identification = identification;
	}

	public String getLogincode() {
		return this.logincode;
	}

	public void setLogincode(String logincode) {
		this.logincode = logincode;
	}

	public String getMemo() {
		return this.memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}
	@ManyToOne(fetch=FetchType.LAZY)
	@JsonIgnore
	public FwOrg getOrgId() {
		return orgId;
	}

	public void setOrgId(FwOrg orgId) {
		this.orgId = orgId;
	}

	public String getPassword() {
		return this.password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	@Enumerated(EnumType.STRING)
	@Column(length=1)
	public sexEnum getSex() {
		return this.sex;
	}

	public void setSex(sexEnum sex) {
		this.sex = sex;
	}

	@Enumerated(EnumType.ORDINAL)
	@Column(length=1)
	public SourceEnum getSource() {
		return source;
	}
	public void setSource(SourceEnum source) {
		this.source = source;
	}
	
	@Enumerated(EnumType.STRING)
	@Column(nullable=false,length=1)
	public StatusEnum getStatus() {
		return this.status;
	}

	public void setStatus(StatusEnum status) {
		this.status = status;
	}

	public String getTelephone() {
		return this.telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	@ManyToOne(fetch=FetchType.LAZY,optional=true)
	@JsonIgnore
	public FwStation getStId() {
		return stId;
	}

	public void setStId(FwStation stId) {
		this.stId = stId;
	}

	// 多对多定义
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(name = "FW_USER_ROLES", joinColumns = { @JoinColumn(name = "USER_ID") }, inverseJoinColumns = { @JoinColumn(name = "ROLE_ID") })
	// 集合按id排序
	@OrderBy("orderNo ASC")
	@JsonIgnore
	public Set<FwRoles> getFwRoles() {
		return fwRoles;
	}

	public void setFwRoles(Set<FwRoles> fwRoles) {
		this.fwRoles = fwRoles;
	}
	
	// 多对多定义
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(name = "FW_USER_PERMISSIONS", joinColumns = { @JoinColumn(name = "USER_ID") }, inverseJoinColumns = { @JoinColumn(name = "PERMISSION_ID") })
	// 集合按id排序
	@OrderBy("orderNo ASC")
	@JsonIgnore
	public Set<FwPermissions> getFwPermissions() {
		return fwPermissions;
	}

	public void setFwPermissions(Set<FwPermissions> fwPermissions) {
		this.fwPermissions = fwPermissions;
	}

	@JsonIgnore
	@Transient
	public boolean isSuperAdminRole() {
		Set<FwRoles> fwRoles = getFwRoles();
		for (FwRoles role : fwRoles) {
			if (FwRoles.RoleEnum.superAdmin.equals(role.getRoleType())  || FwRoles.RoleEnum.admin.equals(role.getRoleType())) {
				return true;
			}
		}
		return false;
	}
	
	@JsonIgnore
	@Transient	
	public Long getCompanyId(){
		FwOrg fwOrg=getOrgId();
		while(fwOrg!=null && !orgEnum.company.equals(fwOrg.getOrgType())){
			fwOrg=fwOrg.getpId();
		}
		return (fwOrg!=null)?fwOrg.getId():null;
	}
	
	public void addRoles(FwRoles fwRole){
		this.fwRoles.add(fwRole);
	}
	
	public void removeRoles(FwRoles fwRole){
		if(this.fwRoles.contains(fwRole)){
		   this.fwRoles.remove(fwRole);
		}
	}

	@Transient
	public String getOrgName() {
		return this.orgId.getOrgName();
	}
	
	@Transient
	public String getStName() {
		return this.stId.getStName();
	}
	
	@Transient
	public Long getOrgCode() {
		return this.orgId.getId();
	}
	
	@Transient
	public Long getStationId() {
		return this.stId.getId();
	}
}