package com.kdgc.framework.web.entity.admin;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Table;
import javax.validation.Valid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kdgc.framework.dao.model.IdEntity;


/**
 * The persistent class for the FW_PENDING_MESSAGE database table.
 * 
 */
@Entity
@Table(name="FW_PENDING_MESSAGE")
public class FwPendingMessage extends IdEntity implements Comparable<FwPendingMessage> {
	private static final long serialVersionUID = 1L;
	
	/**消息类别*/
	public enum MessageType{
		/**待办*/
		pending,
		/** 消息提醒 */
		message	
	}
	/** 消息标题*/
	private String msgTitle;
	/** 消息地址*/
	private String msgUrl;
	/** 消息业务类型*/
	private MessageType busiType = MessageType.pending;
	/** 消息业务ID*/
	private Long businessId;
	/** 消息流程ID*/
	private Long processInstId;
	/** 消息发送人*/
	private Long sendId;		
	/** 消息是否已处理*/
	private boolean isdeal=false;
	
	/** （我的已办）明细url*/
	private String detailUrl;
	
	/** 消息待办接收人员明细*/
	private List<FwPendingDetails> fwPendingDetails=new ArrayList<FwPendingDetails>();
	
	@Column(name="MSG_TITLE")
	public String getMsgTitle() {
		return this.msgTitle;
	}

	public void setMsgTitle(String msgTitle) {
		this.msgTitle = msgTitle;
	}


	@Column(name="MSG_URL")
	public String getMsgUrl() {
		return this.msgUrl;
	}

	public void setMsgUrl(String msgUrl) {
		this.msgUrl = msgUrl;
	}
	
	@Column(name="BUSI_TYPE")
	@Enumerated(EnumType.ORDINAL)
	public MessageType getBusiType() {
		return busiType;
	}

	public void setBusiType(MessageType busiType) {
		this.busiType = busiType;
	}
	
	@Column(name="BUSINESS_ID")
	public Long getBusinessId() {
		return businessId;
	}

	public void setBusinessId(Long businessId) {
		this.businessId = businessId;
	}
	
	@Column(name="PROCESS_INST_ID")
	public Long getProcessInstId() {
		return processInstId;
	}

	public void setProcessInstId(Long processInstId) {
		this.processInstId = processInstId;
	}

	@Column(name="SEND_ID")
	public Long getSendId() {
		return sendId;
	}

	public void setSendId(Long sendId) {
		this.sendId = sendId;
	}
	
	@Column(name="IS_DEAL")
	public boolean getIsdeal() {
		return isdeal;
	}

	public void setIsdeal(boolean isdeal) {
		this.isdeal = isdeal;
	}

	@Column(name="DETAIL_URL")
	public String getDetailUrl() {
		return detailUrl;
	}

	public void setDetailUrl(String detailUrl) {
		this.detailUrl = detailUrl;
	}

	@JsonIgnore
	@Valid
	@ElementCollection(fetch=FetchType.EAGER)
	@CollectionTable(name = "FW_PENDING_DETAILS")
	public List<FwPendingDetails> getFwPendingDetails() {
		return fwPendingDetails;
	}

	public void setFwPendingDetails(List<FwPendingDetails> fwPendingDetails) {
		this.fwPendingDetails = fwPendingDetails;
	}

	public void addPendingDetails(FwPendingDetails fwPendingDetail){
		this.fwPendingDetails.add(fwPendingDetail);
	}

	@Override
	public int compareTo(FwPendingMessage fwPendingMessage) {
		return fwPendingMessage.getCreateDate().compareTo(getCreateDate());
	}
}