package com.kdgc.framework.web.entity.admin;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import org.apache.commons.lang.builder.CompareToBuilder;


/**
 * 待办消息的接收人员事项
 * @author BridgeBai
 *
 */
@Embeddable
public class FwPendingDetails implements Serializable, Comparable<FwPendingDetails> {
	
	private static final long serialVersionUID = -5991309861486460723L;

	/** 消息接收人*/
	private Long receiverId;
	private boolean isDeal=false;
	private boolean isRead=false;
	private Date readTime;	

	public Long getReceiverId() {
		return receiverId;
	}

	public void setReceiverId(Long receiverId) {
		this.receiverId = receiverId;
	}
	
	@Column(name="IS_DEAL")
	public boolean getIsDeal() {
		return isDeal;
	}

	public void setIsDeal(boolean isDeal) {
		this.isDeal = isDeal;
	}
	
	@Column(name="IS_READ")
	public boolean isRead() {
		return isRead;
	}

	public void setRead(boolean isRead) {
		this.isRead = isRead;
	}
	
	@Temporal(TemporalType.DATE)
	@Column(name="READ_TIME")
	public Date getReadTime() {
		return readTime;
	}

	public void setReadTime(Date readTime) {
		this.readTime = readTime;
	}

	/**
	 * 判断是否为空
	 * 
	 * @return 是否为空
	 */
	@Transient
	public boolean isEmpty() {
		return  getReceiverId()==null;
	}

	@Override
	public int compareTo(FwPendingDetails o) {
		return new CompareToBuilder().append(getReceiverId(), o.getReceiverId()).toComparison();
	}

}
