package com.kdgc.framework.web.entity.admin;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import com.kdgc.framework.dao.model.IdEntity;


/**
 * The persistent class for the PORTAL_OPMONITOR_LOG database table.
 * 
 */
@Entity
@Table(name = "FW_OPMONITOR")
public class FwOpMonitor extends IdEntity {
	private static final long serialVersionUID = 1L;
	private String opActioname;
	private String opContent;
	private Long opUserid;
	private String opIp;
	private Date opOptime;
	private boolean opResult;
	private Long opTotaltime;
	private String opUrl;
	private String opUsername;

	public FwOpMonitor() {
	}


	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((opUserid == null) ? 0 : opUserid.hashCode());
		result = prime * result
				+ ((opOptime == null) ? 0 : opOptime.hashCode());
		result = prime * result + ((opUrl == null) ? 0 : opUrl.hashCode());
		return result;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		FwOpMonitor other = (FwOpMonitor) obj;
		if (opUserid == null) {
			if (other.opUserid != null)
				return false;
		} else if (!opUserid.equals(other.opUserid))
			return false;
		if (opOptime == null) {
			if (other.opOptime != null)
				return false;
		} else if (!opOptime.equals(other.opOptime))
			return false;
		if (opUrl == null) {
			if (other.opUrl != null)
				return false;
		} else if (!opUrl.equals(other.opUrl))
			return false;
		return true;
	}
	@Column(name="OP_ACTIONAME")
	public String getOpActioname() {
		return this.opActioname;
	}

	public void setOpActioname(String opActioname) {
		this.opActioname = opActioname;
	}


	@Column(name="OP_CONTENT")
	public String getOpContent() {
		return this.opContent;
	}

	public void setOpContent(String opContent) {
		this.opContent = opContent;
	}


	@Column(name="OP_USERID")
	public Long getOpUserid() {
		return this.opUserid;
	}

	public void setOpUserid(Long opUserid) {
		this.opUserid = opUserid;
	}


	@Column(name="OP_IP")
	public String getOpIp() {
		return this.opIp;
	}

	public void setOpIp(String opIp) {
		this.opIp = opIp;
	}


	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="OP_OPTIME")
	public Date getOpOptime() {
		return this.opOptime;
	}

	public void setOpOptime(Date opOptime) {
		this.opOptime = opOptime;
	}


	@Column(name="OP_RESULT")
	public boolean getOpResult() {
		return this.opResult;
	}

	public void setOpResult(boolean opResult) {
		this.opResult = opResult;
	}


	@Column(name="OP_TOTALTIME")
	public Long getOpTotaltime() {
		return this.opTotaltime;
	}

	public void setOpTotaltime(Long opTotaltime) {
		this.opTotaltime = opTotaltime;
	}


	@Column(name="OP_URL")
	public String getOpUrl() {
		return this.opUrl;
	}

	public void setOpUrl(String opUrl) {
		this.opUrl = opUrl;
	}


	@Column(name="OP_USERNAME")
	public String getOpUsername() {
		return this.opUsername;
	}

	public void setOpUsername(String opUsername) {
		this.opUsername = opUsername;
	}

}