package com.kdgc.framework.web.entity.admin;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kdgc.framework.dao.model.SortEntity;
import com.kdgc.framework.dao.support.StatusEnum;

/**
 * 数据字典数据表
 * @author BridgeBai
 */
@Entity
@Table(name = "FW_DICTIONARY")
public class FwDictionary extends SortEntity {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	/** 数据字典类型*/
	private FwDictionaryType dicTypeId;
	/** 数据字典编码*/
	private String dicCode;
	/** 数据字典值*/
	private String dicValue;
	/** 状态*/
	private StatusEnum status;
	
	@JsonIgnore
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="DIC_TYPEID")
	public FwDictionaryType getDicTypeId() {
		return dicTypeId;
	}

	public void setDicTypeId(FwDictionaryType dicTypeId) {
		this.dicTypeId = dicTypeId;
	}
	@Column(name = "DIC_CODE")
	public String getDicCode() {
		return dicCode;
	}

	public void setDicCode(String dicCode) {
		this.dicCode = dicCode;
	}
	@Column(name = "DIC_VALUE")
	public String getDicValue() {
		return dicValue;
	}

	public void setDicValue(String dicValue) {
		this.dicValue = dicValue;
	}
	
	@Enumerated(EnumType.STRING)
	@Column(nullable=false,length=1)
	public StatusEnum getStatus() {
		return status;
	}

	public void setStatus(StatusEnum status) {
		this.status = status;
	}

}