package com.kdgc.framework.web.dao.admin.nativehelper;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

/***
 * 封装的操作数据库的工具类
 * 
 * @author lchen
 * 
 */
@Repository("NativeSqlHelper")
public class NativeSqlHelper implements INativeSqlHelper{
	@PersistenceContext()
	private EntityManager entityManager;

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#getSingal(java.lang.String)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Object getSingal(String sql) {
		Query query = entityManager.createNativeQuery(sql);
		List list = query.getResultList();
		if (!list.isEmpty()) {
			return (Object) list.get(0);
		} else {
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#getSingal(java.lang.String, java.lang.Object[])
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Object getSingal(String sql, Object[] params) {
		Query query = entityManager.createNativeQuery(sql);
		if (params != null && params.length > 0) {
			for (int i = 0; i < params.length; i++) {
				query.setParameter(i + 1, params[i]);
			}
		}
		List list = query.getResultList();
		if (!list.isEmpty()) {
			return (Object) list.get(0);
		} else {
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#getSingal(java.lang.String, java.lang.Object[], java.lang.Class)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Object getSingal(String sql, Object[] params, Class type) {

		Query query = entityManager.createNativeQuery(sql, type);
		if (params != null && params.length > 0) {
			for (int i = 0; i < params.length; i++) {
				query.setParameter(i + 1, params[i]);
			}
		}
		List list = query.getResultList();
		if (list != null && list.size() > 0) {
			return list.get(0);
		} else {
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#queryByNativeSQL(java.lang.String, int)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public List queryByNativeSQL(String sql, final int... rowStartIdxAndCount) {
		Query query = entityManager.createNativeQuery(sql);
		query.unwrap(SQLQuery.class).setResultTransformer(
				Transformers.ALIAS_TO_ENTITY_MAP);
		if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
			int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
			if (rowStartIdx > 0) {
				query.setFirstResult(rowStartIdx);
			}
			if (rowStartIdxAndCount.length > 1) {
				int rowCount = Math.max(0, rowStartIdxAndCount[1]);
				if (rowCount > 0) {
					query.setMaxResults(rowCount);
				}
			}
		}
		return query.getResultList();
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#queryByNativeSQL(java.lang.String, java.lang.Object[], int)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public List queryByNativeSQL(String sql, Object[] params,
			final int... rowStartIdxAndCount) {
		Query query = entityManager.createNativeQuery(sql);
		query.unwrap(SQLQuery.class).setResultTransformer(
				Transformers.ALIAS_TO_ENTITY_MAP);
		if (params != null && params.length > 0) {
			for (int i = 0; i < params.length; i++) {
				query.setParameter(i + 1, params[i]);
			}
		}
		if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
			int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
			if (rowStartIdx > 0) {
				query.setFirstResult(rowStartIdx);
			}

			if (rowStartIdxAndCount.length > 1) {
				int rowCount = Math.max(0, rowStartIdxAndCount[1]);
				if (rowCount > 0) {
					query.setMaxResults(rowCount);
				}
			}
		}
		return query.getResultList();
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#queryByNativeSQL(java.lang.String, java.lang.Class, int)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public List queryByNativeSQL(String sql, Class type,
			final int... rowStartIdxAndCount) {
		Query query = entityManager.createNativeQuery(sql, type);
		if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
			int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
			if (rowStartIdx > 0) {
				query.setFirstResult(rowStartIdx);
			}

			if (rowStartIdxAndCount.length > 1) {
				int rowCount = Math.max(0, rowStartIdxAndCount[1]);
				if (rowCount > 0) {
					query.setMaxResults(rowCount);
				}
			}
		}
		return query.getResultList();
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#queryByNativeSQL(java.lang.String, java.lang.Object[], java.lang.Class, int)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public List queryByNativeSQL(String sql, Object[] params, Class type,
			final int... rowStartIdxAndCount) {
		Query query = entityManager.createNativeQuery(sql, type);
		if (params != null && params.length > 0) {
			for (int i = 0; i < params.length; i++) {
				query.setParameter(i + 1, params[i]);
			}
		}
		if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
			int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
			if (rowStartIdx > 0) {
				query.setFirstResult(rowStartIdx);
			}

			if (rowStartIdxAndCount.length > 1) {
				int rowCount = Math.max(0, rowStartIdxAndCount[1]);
				if (rowCount > 0) {
					query.setMaxResults(rowCount);
				}
			}
		}
		return query.getResultList();
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#exeNativeSQL(java.lang.String)
	 */
	@Override
	public void exeNativeSQL(String sql) {
		Query query = entityManager.createNativeQuery(sql);
		query.executeUpdate();
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#exeNativeSQL(java.util.List)
	 */
	@Override
	public boolean exeNativeSQL(List sqls) {
		for (Object sql : sqls) {
			Query query = entityManager.createNativeQuery(sql.toString());
			query.executeUpdate();
		}
		entityManager.flush();
		return true;
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#exeBatchSQL(java.util.List)
	 */
	@Override
	public <T> void exeBatchSQL(List<T> beanLs) {
		for (int i = 0; i < beanLs.size(); i++) {
			entityManager.persist(beanLs.get(i));
			if (i % 30 == 0) {
				entityManager.flush();
				entityManager.clear();
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#exeNativeSQL(java.lang.String, java.lang.Object[])
	 */
	@Override
	public int exeNativeSQL(String sql, Object[] params) {
		Query query = entityManager.createNativeQuery(sql);
		if (params != null && params.length > 0) {
			for (int i = 0; i < params.length; i++) {
				query.setParameter(i + 1, params[i]);
			}
		}
		return query.executeUpdate();
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#querySQL(java.lang.String, java.util.List)
	 */
	@Override
	public <T> List<T> querySQL(String sql, List params) {
		Query query = entityManager.createQuery(sql);
		query.setParameter(1, params);
		return query.getResultList();
	}

	/* (non-Javadoc)
	 * @see com.kdgc.framework.web.dao.admin.nativehelper.INativeSqlHelper#pagerNativeSQL(java.lang.String, java.lang.Object[], int, int)
	 */
	@Override
	public PageObject pagerNativeSQL(String sql, Object[] params, int page,
			int rows) {
		int start = (page - 1) * rows;
		PageObject pageobject = new PageObject();
		String sqlCount = "select count(1)  from (" + sql + ") vCount ";
		int count = Integer.parseInt(this.getSingal(sqlCount, params)
				.toString());
		List list = this.queryByNativeSQL(sql.toString(), params, start, rows);
		int totalPage = count % rows == 0 ? count / rows : count / rows + 1;
		pageobject.setTotal(count);
		pageobject.setPageNumber(totalPage);
		pageobject.setCurrpage(page);
		pageobject.setRows(list);
		return pageobject;
	}
}
