package com.kdgc.framework.web.dao.admin.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaBuilder.In;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.stereotype.Repository;

import com.kdgc.framework.dao.jpa.impl.BaseDaoImpl;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.modules.utils.DateUtils;
import com.kdgc.framework.modules.utils.StringUtils;
import com.kdgc.framework.web.dao.admin.IFwUserDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwPendingDetails;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;
import com.kdgc.framework.web.entity.admin.FwPendingMessage.MessageType;
import com.kdgc.framework.web.entity.admin.FwPermissions;
import com.kdgc.framework.web.entity.admin.FwRoles;
import com.kdgc.framework.web.entity.admin.FwRoles.RoleEnum;
import com.kdgc.framework.web.entity.admin.FwStation;
import com.kdgc.framework.web.entity.admin.FwUser;

/**
 * 用户信息Dao层实现
 * 
 * @author BridgeBai
 */
@Repository("FwUserDaoImpl")
public class FwUserDaoImpl extends BaseDaoImpl<FwUser, Long> implements IFwUserDao {
	@Override
	public boolean loginNameExists(String loginName) {
		if (loginName == null) {
			return false;
		}
		String jpql = "select count(*) from FwUser fwUser where lower(fwUser.logincode) = lower(:loginName)";
		Long count = entityManager.createQuery(jpql, Long.class).setFlushMode(FlushModeType.COMMIT).setParameter("loginName", loginName).getSingleResult();
		return count > 0;
	}

	@Override
	public FwUser findByLoginName(String loginName) {
		if (loginName == null) {
			return null;
		}
		try {
			String jpql = "select fwUser from FwUser fwUser join fetch fwUser.orgId  where lower(fwUser.logincode) = lower(:loginName) and fwUser.status=:status";
			return entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("loginName", loginName).setParameter("status", StatusEnum.Y).getSingleResult();
		} catch (NoResultException e) {
			return null;
		}
	}
	
	@Override
	public List<FwUser> findLikeUserName(String userName) {		
		try {
			String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId where fwUser.username like :userName and fwUser.status=:status";
			return entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("userName", "%"+userName+"%").setParameter("status", StatusEnum.Y).getResultList();
		} catch (NoResultException e) {
			return null;
		}
	}
	
	
	@Override
	public Pagination<FwUser> findLikeUserName(String userName,	Pageable pageable) {
		try {
			String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId LEFT JOIN FETCH fwUser.stId where fwUser.username like ?0 and fwUser.status=?1";
			return pagerJPQLList(jpql, new Object[]{"%"+userName+"%",StatusEnum.Y}, pageable);
		} catch (NoResultException e) {
			return null;
		}
	}
	
	@Override
	public List<FwUser> findUsersByDeptCode(List<String> orgCodes){
		//查询上周六到本周五未填报工时的人
		Calendar beginDate = Calendar.getInstance();
		beginDate.add(Calendar.WEEK_OF_MONTH,-1);//周数减一，即上周
		beginDate.set(Calendar.DAY_OF_WEEK, Calendar.SATURDAY);//日子设为周六
		
		Calendar endDate= Calendar.getInstance();
		endDate.set(Calendar.DAY_OF_WEEK, Calendar.FRIDAY);
	    
		Date mindate = DateUtils.getDateMinTime(beginDate.getTime());
		Date maxdate = DateUtils.getDateMaxTime(endDate.getTime());
	    
				String jpql = "select fwUser from FwUser fwUser " +
						"join fetch fwUser.orgId orgId " +
						"where orgId.orgCode in (:orgCodes) " +
						" and fwUser.status = :status" +
						" and fwUser.logincode not in " +
						" (select pmJRsrc.empCode from PmJHour pmJHour,PmJRsrc pmJRsrc" +
						"   where pmJRsrc.id = pmJHour.rsrcId.id " +
						"   and pmJHour.manhourDate between :beginDate and :endDate)" +
						" order by fwUser.orgId,fwUser.orderNo";
				return entityManager.createQuery(jpql, FwUser.class)
					   .setFlushMode(FlushModeType.COMMIT)
					   .setParameter("orgCodes", orgCodes)
					   .setParameter("status", StatusEnum.Y)
					   .setParameter("beginDate", mindate)
					   .setParameter("endDate", maxdate)
					   .getResultList();
	}
	
	@Override
	public List<FwUser> findUsersByDeptAndStCode(List<FwOrg> fwOrgs,String stCode){
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwUser> criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
		Root<FwUser> root = criteriaQuery.from(FwUser.class);
		criteriaQuery.select(root);
		Predicate restrictions = criteriaBuilder.conjunction();		
		if(fwOrgs!=null && fwOrgs.size()>0){
			Iterator<FwOrg> iterator = fwOrgs.iterator();
	        In<FwOrg> in = criteriaBuilder.in(root.<FwOrg>get("orgId"));
	        while (iterator.hasNext()) {
	            in.value(iterator.next());
	        }
			restrictions = criteriaBuilder.and(restrictions, in);
		}
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("status"), StatusEnum.Y));
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.<FwStation>get("stId").get("stCode"),stCode));
		criteriaQuery.where(restrictions);			
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("orgId"));
		orders.add(Order.asc("orderNo"));
		return super.findList(criteriaQuery, null, null, null, orders);
	}
	@Override
	public List<FwUser> findOrgUsers(FwOrg fwOrg) {
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwUser> criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
		Root<FwUser> root = criteriaQuery.from(FwUser.class);
		criteriaQuery.select(root);
		Predicate restrictions = criteriaBuilder.conjunction();		
		if(fwOrg!=null){
			restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("orgId"), fwOrg));
		}
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("status"), StatusEnum.Y));
		criteriaQuery.where(restrictions);			
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("orgId"));
		orders.add(Order.asc("orderNo"));
		return super.findList(criteriaQuery, null, null, null, orders);
	}
	
	@Override
	public List<FwUser> findUsersNotInOrgs(List<FwOrg> fwOrgs) {
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwUser> criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
		Root<FwUser> root = criteriaQuery.from(FwUser.class);
		criteriaQuery.select(root);
		Predicate restrictions = criteriaBuilder.conjunction();		
		if(fwOrgs!=null && fwOrgs.size()>0){
			Iterator<FwOrg> iterator = fwOrgs.iterator();
	        In<FwOrg> in = criteriaBuilder.in(root.<FwOrg>get("orgId"));
	        while (iterator.hasNext()) {
	            in.value(iterator.next());
	        }
			restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.not(in));
		}
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("status"), StatusEnum.Y));
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.isNotNull(root.get("email")));
		criteriaQuery.where(restrictions);			
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("orgId"));
		orders.add(Order.asc("orderNo"));
		return super.findList(criteriaQuery, null, null, null, orders);
	}
	
	@Override
	public Pagination<FwUser> findWaitMember(List<Long> memberIds,
			String queryName, Integer start, Integer limit) {
		StringBuffer resultCount = new StringBuffer("SELECT COUNT(*) FROM FwUser fwUser WHERE 1 = 1 ");
		if (!memberIds.isEmpty()) {
			resultCount.append("AND fwUser.id NOT IN :memberIds ");
		}
		if (!StringUtils.isEmpty(queryName)) {
			resultCount.append("AND fwUser.username LIKE :userName ");
		}
		Query countQuery = entityManager.createQuery(resultCount.toString());
		if (!memberIds.isEmpty()) {
			countQuery.setParameter("memberIds", memberIds);
		}
		if (!StringUtils.isEmpty(queryName)) {
			countQuery.setParameter("userName", "%" + queryName + "%");
		}
		Long count = Long.parseLong(countQuery.getSingleResult().toString());
		List<FwUser> list = new ArrayList<FwUser>();
		if (count > 0) {
			StringBuffer jpql = new StringBuffer("SELECT fwUser FROM FwUser fwUser WHERE 1 = 1 ");
			if (!memberIds.isEmpty()) {
				jpql.append("AND fwUser.id NOT IN :memberIds ");
			}
			if (!StringUtils.isEmpty(queryName)) {
				jpql.append("AND fwUser.username LIKE :userName ");
			}
			jpql.append("ORDER BY fwUser.orgId, fwUser.id");
			TypedQuery<FwUser> query = entityManager.createQuery(jpql.toString(),FwUser.class);
			if (!memberIds.isEmpty()) {
				query.setParameter("memberIds", memberIds);
			}
			if (!StringUtils.isEmpty(queryName)) {
				query.setParameter("userName", "%" + queryName + "%");
			}
			query.setFirstResult(start);
			query.setMaxResults(start + limit);
			list = query.getResultList();
		}
		Pagination<FwUser> result = new Pagination<FwUser>(list, count, null);
		return result;
	}

	@Override
	public void deleteUser(List<Long> userIds) {
		String jpql = "UPDATE FwUser fwUser SET fwUser.status = 'N' WHERE fwUser.id IN :ids";
		Query query = entityManager.createQuery(jpql);
		query.setParameter("ids", userIds);
		query.executeUpdate();
	}
	
	/**
	 * 功能 : 查询人员部门弹出框
	 * 开发：wwzhang 2015-11-5 下午4:25:29
	 * @param deptId部门id
	 * @param userName 用户姓名
	 * @param page     页
	 * @param rows     每页行数
	 * @return
	 * @throws Exception
	 */
	public List<FwUser> findUserAndOrg(String deptId, String userName,int page,int rows){
		
		String temp = "" ;
		if (!StringUtils.isEmpty(userName)) {
			temp += " and fwUser.username like '%"+userName+"%' ";
		}
		
		if(!StringUtils.isEmpty(deptId)){
			temp += " and orgId.id = '"+deptId+"' ";
		}
		try {
			String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId orgId "  +
					"where fwUser.status=:status" +temp
					+ " order by orgId.orgCode";
			
			List<FwUser> list = entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("status", StatusEnum.Y)
					.setFirstResult((page-1)*rows).setMaxResults(rows)
					.getResultList();
			
			return list;
		} catch (NoResultException e) {
			return null;
		}
	}
	
	/**
	 * 
	 * 功能 :查询数据个总数
	
	 * 开发：wwzhang 2015-11-9
	
	 * @param deptId      部门id
	 * @param userName    用户姓名
	 * @return
	 */
	public Long getCount(String deptId, String userName){
		String temp = "" ;
		if (!StringUtils.isEmpty(userName)) {
			temp += " and fwUser.username like '%"+userName+"%' ";
		}
		
		if(!StringUtils.isEmpty(deptId)){
			temp += " and orgId.id = '"+deptId+"' ";
		}
		try {
			String jpql = "select fwUser from FwUser fwUser JOIN FETCH fwUser.orgId orgId "  +
					"where fwUser.status=:status" +temp;
			
			List<FwUser> list = entityManager.createQuery(jpql, FwUser.class).setFlushMode(FlushModeType.COMMIT).setParameter("status", StatusEnum.Y)
					.getResultList();
			
			return (long) list.size();
		} catch (NoResultException e) {
			return null;
		}
	}

	@Override
	public List<FwUser> findUserByRoleType(RoleEnum roleEnum) {
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwUser> criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
		Root<FwUser> root = criteriaQuery.from(FwUser.class);
		Join<FwUser,FwRoles> fwRolesJoin=root.join("fwRoles");	
		criteriaQuery.select(root);
		Predicate restrictions = criteriaBuilder.conjunction();		
		if(roleEnum!=null){
			restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(fwRolesJoin.<RoleEnum> get("roleType"), roleEnum));
		}
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("status"), StatusEnum.Y));
		criteriaQuery.where(restrictions);			
		return entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
	}
	@Override
	public List<FwUser> findUserByPermisson(String permissionCode) {
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwUser> criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
		Root<FwUser> root = criteriaQuery.from(FwUser.class);
		Join<FwUser,FwPermissions> fwPermissionsJoin=root.join("fwPermissions");	
		criteriaQuery.select(root);
		Predicate restrictions = criteriaBuilder.conjunction();		
		if(StringUtils.isNotBlank(permissionCode)){
			restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(fwPermissionsJoin.<String> get("permissionCode"), permissionCode));
		}
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("status"), StatusEnum.Y));
		criteriaQuery.where(restrictions);			
		return entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
	}
	@Override
	public List<FwUser> findUserByRolePermisson(String permissionCode) {
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwUser> criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
		Root<FwUser> root = criteriaQuery.from(FwUser.class);
		Join<FwUser,FwRoles> fwRolesJoin=root.join("fwRoles");	
		Join<FwRoles,FwPermissions> fwPermissionsJoin=fwRolesJoin.join("fwPermissions");
		criteriaQuery.select(root);
		Predicate restrictions = criteriaBuilder.conjunction();		
		if(permissionCode!=null){
			restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(fwPermissionsJoin.<String> get("permissionCode"), permissionCode));
		}
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("status"), StatusEnum.Y));
		criteriaQuery.where(restrictions);			
		return entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
	}
	@Override
	public List<FwUser> findUserByStationPermisson(String permissionCode) {
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwUser> criteriaQuery = criteriaBuilder.createQuery(FwUser.class);
		Root<FwUser> root = criteriaQuery.from(FwUser.class);
		Join<FwUser,FwStation> fwStationJoin=root.join("stId");	
		Join<FwStation,FwPermissions> fwPermissionsJoin=fwStationJoin.join("fwPermissions");
		criteriaQuery.select(root);
		Predicate restrictions = criteriaBuilder.conjunction();		
		if(permissionCode!=null){
			restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(fwPermissionsJoin.<String> get("permissionCode"), permissionCode));
		}
		restrictions = criteriaBuilder.and(restrictions, criteriaBuilder.equal(root.get("status"), StatusEnum.Y));
		criteriaQuery.where(restrictions);			
		return entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT).getResultList();
	}

	@Override
	public Pagination<FwUser> findUserList(Long orgId,String userNameOrCode, Pageable pageable) {		
		String tempString = "";
		Map<String,Object> params=new HashMap<String,Object>();
		if (!StringUtils.isEmpty(orgId)) {
			 tempString += " and fwUser.orgId.id = :orgId " ;
			 params.put("orgId", orgId);
		}
		if (!StringUtils.isEmpty(userNameOrCode)) {
			tempString += " and (fwUser.username like '%"+userNameOrCode+"%' or fwUser.logincode like '%"+userNameOrCode+"%')";
		}
			
		try {
			String jpql = "select distinct fwUser from FwUser fwUser "
					+ "JOIN FETCH fwUser.orgId  fwOrg " 
					+"LEFT JOIN FETCH fwUser.stId fwStation " 
					+"where fwUser.status =:dataStat "+tempString +"order by fwUser.orderNo";
			params.put("dataStat", StatusEnum.Y);
			return pagerJPQLList(jpql,params, pageable);
		} catch (NoResultException e) {
			return null;
		}
		
	}

	@Override
	public List<FwUser> findNotDealMessage() {
		
		List<Long> userIds = new ArrayList<Long>();
		
		String jpql = "select fwPendingMessage from FwPendingMessage fwPendingMessage " +
				      " where fwPendingMessage.busiType = :busiType " +
				      " and fwPendingMessage.isdeal = :isdeal";
		List <FwPendingMessage>	list = entityManager.createQuery(jpql, FwPendingMessage.class)
		   .setFlushMode(FlushModeType.COMMIT)
		   .setParameter("busiType", MessageType.pending)
		   .setParameter("isdeal", false)
		   .getResultList();
		
		for(FwPendingMessage entity : list){
			List<FwPendingDetails> detailList = entity.getFwPendingDetails();
			for(FwPendingDetails detail : detailList){
				if(!detail.getIsDeal() && !userIds.contains(detail.getReceiverId())){
					userIds.add(detail.getReceiverId());
				}
			}
		}
		
		String userjpql = "select fwUser from FwUser fwUser " +
				"join fetch fwUser.orgId orgId " +
				"where fwUser.status = :status" +
				" and fwUser.id in (:userIds)" +
				" order by fwUser.orgId,fwUser.orderNo";
		return entityManager.createQuery(userjpql, FwUser.class)
			   .setFlushMode(FlushModeType.COMMIT)
			   .setParameter("userIds", userIds)
			   .setParameter("status", StatusEnum.Y)
			   .getResultList();
		
	}
}