package com.kdgc.framework.web.dao.admin.impl;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.stereotype.Repository;

import com.kdgc.framework.dao.jpa.impl.BaseDaoImpl;
import com.kdgc.framework.modules.utils.DateUtils;
import com.kdgc.framework.web.dao.admin.IFwPendingMessageDao;
import com.kdgc.framework.web.entity.admin.FwPendingDetails;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;

@Repository("FwPendingMessageDaoImpl")
public class FwPendingMessageDaoImpl extends BaseDaoImpl<FwPendingMessage, Long> implements	IFwPendingMessageDao {

	@Override
	public List<FwPendingMessage> queryUserPendingMsg(Long userId) {
		if(userId==null){
			return null;
		}
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwPendingMessage> criteriaQuery = criteriaBuilder.createQuery(FwPendingMessage.class);
		Root<FwPendingMessage> root = criteriaQuery.from(FwPendingMessage.class);
		Join<FwPendingMessage, FwPendingDetails> fwPendingDetails = root.join("fwPendingDetails");
		criteriaQuery.select(root);
		criteriaQuery.distinct(true);
		Predicate restrictions=criteriaBuilder.conjunction();			
		restrictions=criteriaBuilder.and(restrictions,criteriaBuilder.equal(root.<Boolean>get("isdeal"), false),criteriaBuilder.equal(fwPendingDetails.<Long>get("receiverId"),userId),criteriaBuilder.equal(fwPendingDetails.<Boolean>get("isDeal"),false));
		criteriaQuery.where(restrictions);
		criteriaQuery.orderBy(criteriaBuilder.desc(root.<Date>get("createDate")));
		TypedQuery<FwPendingMessage> query = entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
		return query.getResultList();
	}

	@Override
	public List<FwPendingMessage> findFwMessageByBusiness(Long business) {
		if(business==null){
			return null;
		}	
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwPendingMessage> criteriaQuery = criteriaBuilder.createQuery(FwPendingMessage.class);
		Root<FwPendingMessage> root = criteriaQuery.from(FwPendingMessage.class);
		
		criteriaQuery.select(root);
		criteriaQuery.distinct(true);
		Predicate restrictions=criteriaBuilder.conjunction();			
		restrictions=criteriaBuilder.and(restrictions,criteriaBuilder.equal(root.<Boolean>get("isdeal"), false),criteriaBuilder.equal(root.<Long>get("businessId"),business));
		criteriaQuery.where(restrictions);
		criteriaQuery.orderBy(criteriaBuilder.desc(root.<Date>get("createDate")));
		TypedQuery<FwPendingMessage> query = entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
		return query.getResultList();
	}

	@Override
	public List<FwPendingMessage> queryUserAlreadyPendingMsg(Long userId) throws ParseException {
		if(userId==null){
			return null;
		}
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<FwPendingMessage> criteriaQuery = criteriaBuilder.createQuery(FwPendingMessage.class);
		Root<FwPendingMessage> root = criteriaQuery.from(FwPendingMessage.class);
		Join<FwPendingMessage, FwPendingDetails> fwPendingDetails = root.join("fwPendingDetails");
		criteriaQuery.select(root);
		criteriaQuery.distinct(true);
		Predicate restrictions=criteriaBuilder.conjunction();	
		
		restrictions=criteriaBuilder.and(restrictions,criteriaBuilder.equal(root.<Boolean>get("isdeal"), true),
				                         criteriaBuilder.equal(fwPendingDetails.<Long>get("receiverId"),userId),
				                         criteriaBuilder.equal(fwPendingDetails.<Boolean>get("isDeal"),true),
				                         criteriaBuilder.greaterThanOrEqualTo(fwPendingDetails.<Date>get("readTime"), DateUtils.addMonth(new Date(), -1)),
				                         criteriaBuilder.lessThanOrEqualTo(fwPendingDetails.<Date> get("readTime"), new Date()));
		
		criteriaQuery.where(restrictions);
		criteriaQuery.orderBy(criteriaBuilder.desc(root.<Date>get("modifyDate")));
		TypedQuery<FwPendingMessage> query = entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
		return query.getResultList();
	}

	
}
