package com.kdgc.framework.web.dao.admin.impl;

import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.kdgc.framework.dao.jpa.impl.BaseDaoImpl;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.web.dao.admin.IFwOrgDao;
import com.kdgc.framework.web.entity.admin.FwOrg;
@Repository("FwOrgDaoImpl")
public class FwOrgDaoImpl extends BaseDaoImpl<FwOrg, Long> implements IFwOrgDao {
	
	
	@Transactional(readOnly = true)
	@Override
	public FwOrg findFwOrgs(Long deptId){
		try {
			String jpql = "select distinct fwOrg from FwOrg fwOrg "
					+ "LEFT JOIN FETCH fwOrg.children "
					+ "where fwOrg.status =:status and fwOrg.id=:deptId"  ;
			return entityManager.createQuery(jpql, FwOrg.class)
					.setFlushMode(FlushModeType.COMMIT)
					.setParameter("status", StatusEnum.Y).setParameter("deptId", deptId).getSingleResult();
		} catch (NoResultException e) {
			return null;
		}
	}

	@Transactional(readOnly = true)
	@Override
	public FwOrg findParentFwOrg(Long orgId){
		try {
			String jpql = "select distinct fwOrg.pId from FwOrg fwOrg "
					+ "where fwOrg.status =:status and fwOrg.id=:orgId"  ;
			return entityManager.createQuery(jpql, FwOrg.class)
					.setFlushMode(FlushModeType.COMMIT)
					.setParameter("status", StatusEnum.Y).setParameter("orgId", orgId).getSingleResult();
		} catch (NoResultException e) {
			return null;
		}
	}
}
