package com.kdgc.framework.web.dao.admin.impl;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;

import org.springframework.stereotype.Repository;

import com.kdgc.framework.dao.jpa.impl.BaseDaoImpl;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.modules.utils.StringUtils;
import com.kdgc.framework.web.dao.admin.IFwDictionaryTypeDao;
import com.kdgc.framework.web.entity.admin.FwDictionaryType;

/**
 * 数据字典类型Dao接口实现
 * 
 * @author BridgeBai
 * 
 */
@Repository("FwDictionaryTypeDaoImpl")
public class FwDictionaryTypeDaoImpl extends BaseDaoImpl<FwDictionaryType, Long> implements IFwDictionaryTypeDao{
	
	@Override
	public FwDictionaryType findDictionarys(String dictTypeCode) {
		if (dictTypeCode != null) {			
			try {
				String jpql = "select fwDictionaryType from FwDictionaryType fwDictionaryType join fetch fwDictionaryType.fwDictionarys where lower(fwDictionaryType.dicTypeCode) = lower(:dictTypeCode)";
				FwDictionaryType fwDictionaryType= entityManager.createQuery(jpql, FwDictionaryType.class).setFlushMode(FlushModeType.COMMIT).setParameter("dictTypeCode", dictTypeCode).getSingleResult();
				return fwDictionaryType;
			} catch (NoResultException e) {
				return null;
			}
		}
		return null;
	}

	@Override
	public Pagination<FwDictionaryType> findDicTypeList(String dicTypeName, Pageable pageable) {
		String tempString = "";
		Map<String,Object>params=new HashMap<String,Object>();
		 if (!StringUtils.isEmpty(dicTypeName)) {
			 tempString += " where fwDictionaryType.dicTypeName like :dicTypeName " ;
			 params.put("dicTypeName", "%"+dicTypeName.trim() + "%");	
		 }
		 try {
			String jpql = "select distinct fwDictionaryType from FwDictionaryType fwDictionaryType "
					+ tempString + " order by fwDictionaryType.createDate desc";
			return pagerJPQLList(jpql,params,  pageable);
				
		} catch (NoResultException e) {
			return null;
		}
	}
	
}