package com.kdgc.framework.web.dao.admin.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;

import com.kdgc.framework.dao.jpa.impl.BaseDaoImpl;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.dao.support.StatusEnum;
import com.kdgc.framework.modules.utils.StringUtils;
import com.kdgc.framework.web.dao.admin.IFwDictionaryDao;
import com.kdgc.framework.web.entity.admin.FwDictionary;

/**
 * 数据字典Dao层实现
 * 
 * @author BridgeBai
 * 
 */
@Repository("FwDictionaryDaoImpl")
public class FwDictionaryDaoImpl extends BaseDaoImpl<FwDictionary, Long> implements IFwDictionaryDao {

	@Override
	public void removeDictionary(Long[] ids) {
		String jqpl = "DELETE FROM FwDictionary fwDictionary WHERE fwDictionary.id in :ids";
		List<Long> idsList = Arrays.asList(ids);
		Query query = entityManager.createQuery(jqpl);
		query.setParameter("ids", idsList);
		query.executeUpdate();
	}

	@Override
	public Pagination<FwDictionary> findDicList(Long dicTypeId, Pageable pageable) {
		String tempString = "";
		Map<String,Object>params=new HashMap<String,Object>();
		 if (!StringUtils.isEmpty(dicTypeId)) {
			 tempString += " and fwDictionary.dicTypeId.id like :dicTypeId " ;
			 params.put("dicTypeId",dicTypeId);	
		 }else{
			 return new Pagination<FwDictionary>();
		 }
		 try {
			String jpql = "select distinct fwDictionary from FwDictionary fwDictionary "
					+ "where fwDictionary.status = :status "
					+ tempString + " order by fwDictionary.orderNo";
			params.put("status", StatusEnum.Y);
			return pagerJPQLList(jpql,params,  pageable);
				
		} catch (NoResultException e) {
			return null;
		}
	}


}