package com.kdgc.framework.web.dao.admin;



import java.util.List;

import com.kdgc.framework.dao.jpa.IBaseDao;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.web.entity.admin.FwOrg;
import com.kdgc.framework.web.entity.admin.FwUser;
import com.kdgc.framework.web.entity.admin.FwRoles.RoleEnum;

/**
 * 用户信息Dao层接口定义
 * 
 * @author BridgeBai
 */
public interface IFwUserDao extends IBaseDao<FwUser, Long> {

	/**
	 * 判断用户名是否存在
	 * 
	 * @param loginName
	 *            用户名(忽略大小写)
	 * @return 用户名是否存在
	 */
	boolean loginNameExists(String loginName);

	/**
	 * 根据登录账号查找用户
	 * 
	 * @param loginName
	 *            用户名(忽略大小写)
	 * @return 管理员，若不存在则返回null
	 */
	FwUser findByLoginName(String loginName);
	/**
	 * 根据用户姓名模糊查询用户信息
	 * @param userName
	 * @return
	 */
	public List<FwUser> findLikeUserName(String userName);
	/**
	 * 功能：根据用户姓名模糊查询用户信息
	 * @author BridgeBai
	 * @date   2015年11月16日下午4:11:26
	 * @param userName 用户姓名
	 * @param pageable 分页对象
	 * @return
	 */
	public Pagination<FwUser> findLikeUserName(String userName,Pageable pageable);
	
	/**
	 * 功能：根据单位编码查询指定单位的人员
	 * @author BridgeBai
	 * @date   2016年6月6日下午8:13:24
	 * @param orgCodes
	 * @return
	 */
	public List<FwUser> findUsersByDeptCode(List<String> orgCodes);
	/**
	 * 功能：查询所指定的单位内具有指定岗位编码的人员
	 * @author BridgeBai
	 * @date   2016年4月19日下午6:47:24
	 * @param fwOrgs 单位
	 * @param stCode 岗位编码
	 * @return
	 */
	public List<FwUser> findUsersByDeptAndStCode(List<FwOrg> fwOrgs,String stCode);
    /**
     * 获取组织机构下用户信息
     * @param fwOrg 组织机构
     * @return
     */
	public List<FwUser> findOrgUsers(FwOrg fwOrg);
	
	public List<FwUser> findUsersNotInOrgs(List<FwOrg> fwOrgs);
	/**
	 * 功能 : 查询未被选为项目组成员的人员
	 * 开发：zwwang 2015-6-13 上午11:00:40
	 * @param memberIds 已被选为项目组成员人员的id
	 * @param queryName
	 * @param start
	 * @param limit
	 * @return
	 */
	public Pagination<FwUser> findWaitMember(List<Long> memberIds, String queryName, Integer start, Integer limit);
	
	/**
	 * 功能 : 删除用户
	 * 开发：zwwang 2015-6-16 下午2:43:28
	 * @param userIds 被删除数据的id
	 */
	public void deleteUser(List<Long> userIds);

	/**
	 * 功能 : 查询人员部门弹出框
	 * 开发：wwzhang 2015-11-7 下午4:25:29
	 * @param deptId部门id
	 * @param userName 用户姓名
	 * @return
	 * @throws Exception
	 */
	public List<FwUser> findUserAndOrg(String deptId, String userName,int page,int rows);

	/**
	 * 
	 * 功能 :查询数据个总数
	
	 * 开发：wwzhang 2015-11-9
	
	 * @param deptId      部门id
	 * @param userName    用户姓名
	 * @return
	 */
	Long getCount(String deptId, String userName);
	/**
	 * 功能：根据角色类别查询人员信息
	 * @author BridgeBai
	 * @date   2015年11月23日下午3:58:27
	 * @param roleEnum 角色类别
	 * @return
	 */
	public List<FwUser> findUserByRoleType(RoleEnum roleEnum);
	/**
	 * 功能：根据权限编码查询对应的人员
	 * @author BridgeBai
	 * @date   2015年11月24日下午8:17:45
	 * @param permissionCode
	 * @return
	 */
	public List<FwUser> findUserByPermisson(String permissionCode);
	/**
	 * 功能：根据权限编码查询角色对应的人员
	 * @author BridgeBai
	 * @date   2015年11月24日下午8:17:45
	 * @param permissionCode
	 * @return
	 */
	public List<FwUser> findUserByRolePermisson(String permissionCode);
	/**
	 * 功能：根据权限编码查询岗位对应的人员
	 * @author BridgeBai
	 * @date   2015年11月24日下午8:17:45
	 * @param permissionCode
	 * @return
	 */
	public List<FwUser> findUserByStationPermisson(String permissionCode);
	/**
	 * 
	 * @Title: findUserList 
	 * @author: hwzhu   
	 * @date: 2016年3月11日 上午11:15:43
	 * @Description: 通过组织Id查询该组织下所有用户，（其中组织树根节点查询 所有）
	 * @param orgId
	 * @param pageable
	 * @return
	 * @return: Pagination<FwUser>
	 */
	public Pagination<FwUser> findUserList(Long orgId,String userNameOrCode,Pageable pageable);

	/**
	 * 
	 * 功能 :查询有待办的用户
	
	 * 开发：wwzhang 2016-6-17
	
	 * @return
	 */
	public List<FwUser> findNotDealMessage();
}