package com.kdgc.framework.web.dao.admin;

import java.text.ParseException;
import java.util.List;

import com.kdgc.framework.dao.jpa.IBaseDao;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;

public interface IFwPendingMessageDao extends IBaseDao<FwPendingMessage, Long> {

	/**
	 * 查询当前人员的待办消息
	 * @param userId
	 * @return
	 */
	public List<FwPendingMessage> queryUserPendingMsg(Long userId);
	
	/**
	 * 根据业务表的id查询消息实体
	 * @param business  业务表id
	 */
	public List<FwPendingMessage> findFwMessageByBusiness(Long business);

	/**
	 * 
	 * 功能 :查询已办
	
	 * 开发：wwzhang 2016-6-27
	
	 * @param id
	 * @return
	 * @throws ParseException 
	 */
	public List<FwPendingMessage> queryUserAlreadyPendingMsg(Long id) throws ParseException;
}
