package com.kdgc.framework.web.dao.admin;

import com.kdgc.framework.dao.jpa.IBaseDao;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.web.entity.admin.FwDictionaryType;
/**
 * 数据字典类型Dao层接口定义
 * @author BridgeBai
 *
 */
public interface IFwDictionaryTypeDao extends IBaseDao<FwDictionaryType, Long> {

	/**
	 * 查询类型编码下的所有类型数据
	 * @param dictTypeCode 类型编码
	 * @return
	 */
	public FwDictionaryType findDictionarys(String dictTypeCode);
	
	
	/**
	 * 
	 * @Title: findDicTypeList 
	 * @author: hwzhu   
	 * @date: 2016年3月17日 下午6:20:14
	 * @Description: 查询字典类型列表
	 * @param dicTypeName
	 * @param pageable
	 * @return
	 * @return: Pagination<FwDictionaryType>
	 */
	public Pagination<FwDictionaryType> findDicTypeList(String dicTypeName, Pageable pageable);
}
