package com.kdgc.framework.web.dao.admin;

import com.kdgc.framework.dao.jpa.IBaseDao;
import com.kdgc.framework.dao.support.Pageable;
import com.kdgc.framework.dao.support.Pagination;
import com.kdgc.framework.web.entity.admin.FwDictionary;

/**
 * 数据字典Dao层接口定义
 * @author BridgeBai
 *
 */
public interface IFwDictionaryDao extends IBaseDao<FwDictionary, Long> {
	/**
	 * 功能 : 根据id删除字典项
	 * 开发：zwwang 2015-5-7 上午10:31:36
	 * @param ids
	 * @return
	 */
	public void removeDictionary(Long[] ids);
	
	/**
	 * 
	 * @Title: findDicList 
	 * @author: hwzhu   
	 * @date: 2016年3月18日 下午2:53:04
	 * @Description: 根据字典类型查询字典明细
	 * @param dicTypeId
	 * @param pageable
	 * @return
	 * @return: Pagination<FwDictionary>
	 */
	public Pagination<FwDictionary> findDicList(Long dicTypeId, Pageable pageable);
}
