package com.kdgc.framework.web.common.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
	private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);
	
	
     /**
     * 功能： post请求
     * @author BridgeBai
     * @date   2016年6月13日下午2:57:04
     * @param url    url地址
     * @param params 参数
     * @return
     * @throws UnsupportedEncodingException
     */
    public static String httpPost(String url,Map<String,String> params) throws UnsupportedEncodingException{
		String retData=null;
		CloseableHttpClient httpclient = HttpClients.createDefault();
		HttpPost httppost = new HttpPost(url);
		List<NameValuePair> formparams = new ArrayList<NameValuePair>();  
		if(params!=null){
			for(Map.Entry<String, String> entry:params.entrySet()){
			  formparams.add(new BasicNameValuePair(entry.getKey(),entry.getValue()));
			}
		}
        UrlEncodedFormEntity uefEntity=new UrlEncodedFormEntity(formparams, "GBK");
        httppost.setEntity(uefEntity); 
        httppost.setHeader("Content-Type", "application/x-www-form-urlencoded"); 
		RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(15000).setConnectionRequestTimeout(15000).build();
		httppost.setConfig(requestConfig);
		CloseableHttpResponse res = null;
		try {
			res = httpclient.execute(httppost);
			HttpEntity resEntity = res.getEntity();
			if(resEntity != null){
				retData = EntityUtils.toString(resEntity);
			}
			EntityUtils.consume(resEntity);
		}catch(Exception e){
			logger.error(e.getMessage(), e);	
		} finally {
			if (res != null) {
				try {
					res.close();
				} catch (IOException e) {
					logger.error(e.getMessage(), e);
				}
			}
			try {
				httpclient.close();
			} catch (IOException e) {
				logger.error(e.getMessage(), e);
			}
		}
	  return retData;
    }
    /**
     * 功能：get请求
     * @author BridgeBai
     * @date   2016年6月13日下午3:28:34
     * @param url url地址
     * @return
     */
    public static String httpGet(String url){
    	String retData=null;
		CloseableHttpClient httpclient = HttpClients.createDefault();
		HttpGet httpGet = new HttpGet(url);
		CloseableHttpResponse res = null;
		try {
			res = httpclient.execute(httpGet);
			HttpEntity resEntity = res.getEntity();
			if(resEntity != null){
				retData = EntityUtils.toString(resEntity);
			}
			EntityUtils.consume(resEntity);
		}catch(Exception e){
			logger.error(e.getMessage(), e);
		} finally {
			if (res != null) {
				try {
					res.close();
				} catch (IOException e) {
					logger.error(e.getMessage(), e);
				}
			}
			try {
				httpclient.close();
			} catch (IOException e) {
				logger.error(e.getMessage(), e);
			}
		}
	    return retData;
    }
}
