package com.kdgc.framework.web.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.core.io.support.PropertiesLoaderSupport;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import com.kdgc.framework.core.spring.SpringContextHolder;
import com.kdgc.framework.web.common.FileInfo.FileType;

public class FileUtil {

   private static Logger logger=LoggerFactory.getLogger(FileUtil.class);
   private static Properties properties=new Properties();
   static{  
	   try{
	    String[] postProcessorNames = SpringContextHolder.getApplicationContext().getBeanNamesForType(BeanFactoryPostProcessor.class,true,true);
	    for (String ppName : postProcessorNames) {
	        BeanFactoryPostProcessor beanProcessor=(BeanFactoryPostProcessor) SpringContextHolder.getBean(ppName,BeanFactoryPostProcessor.class);
	        if(beanProcessor instanceof PropertyResourceConfigurer){
	        	PropertyResourceConfigurer propertyResourceConfigurer=(PropertyResourceConfigurer) beanProcessor;
				Method mergeProperties=PropertiesLoaderSupport.class.getDeclaredMethod("mergeProperties");  
				mergeProperties.setAccessible(true);  
				Properties props = (Properties) mergeProperties.  
				invoke(propertyResourceConfigurer); 
				Method convertProperties=PropertyResourceConfigurer.class.  
				getDeclaredMethod("convertProperties", Properties.class);  			
				convertProperties.setAccessible(true);  
				convertProperties.invoke(propertyResourceConfigurer, props);
				properties.putAll(props);
	        }
	    }
     } catch (Exception e) {
		throw new RuntimeException(e);
	 }  
   }
   /**
    * 功能：获取属性配置文件的配置值
    * @author BridgeBai
    * @date   2015年11月19日下午6:53:57
    * @param propertyName 属性键名
    * @return
    */
   public static String getProperty(String propertyName){  
	  return properties.getProperty(propertyName);  
   }  
	/**
	 * 判断文件是否为合法有效的文件类型
	 * @param multipartFile
	 * @return
	 */
	public static boolean isValid(MultipartFile multipartFile){
		return FilenameUtils.isExtension(multipartFile.getOriginalFilename(), FileType.getFileExts());
	}
	
	/**
	 * 上传文件
	 * @param request
	 * @param targetPath
	 * @return
	 */
	public static  boolean multiFileUpload(HttpServletRequest request,String targetPath){
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
		if(multipartResolver.isMultipart(request)){ //判断request是否有文件上传
			MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
			Iterator<String> ite = multiRequest.getFileNames();
			while(ite.hasNext()){
				MultipartFile file = multiRequest.getFile(ite.next());
				if(file!=null){
					File localFile = new File((targetPath.endsWith("/")?targetPath:targetPath+"/")+file.getOriginalFilename());
					try {
						file.transferTo(localFile); //将上传文件写到服务器上指定的文件
					} catch (IllegalStateException e) {
						logger.error("文件上传失败!", e);
					} catch (IOException e) {
						logger.error("文件读写错误!", e);
					}
				}
			}
		}		
		return true;
	}
	/**
	 * 上传文件
	 * 
	 * @param file
	 * @param targetPath 文件存储子目录
	 * @return
	 * @throws Exception
	 */
	public static  String fileUpload(MultipartFile file,String targetPath){
		targetPath=properties.getProperty("upload.file.path")+"\\"+targetPath+"\\";
		String fileName = file.getOriginalFilename();
		String suffix = fileName.substring(fileName.lastIndexOf("."));
		String lastFileName = UUID.randomUUID().toString() + suffix;
		if (!targetPath.endsWith(File.separator)) {
			targetPath = targetPath + File.separator;
		}
		File temp = new File(targetPath);
		if (!temp.exists()||!temp.isDirectory()) {
			temp.mkdirs();
		}
		String fileFullPath = targetPath + lastFileName;
		try {
			FileCopyUtils.copy(file.getBytes(), new File(fileFullPath));
			return lastFileName;
		} catch (IOException e) {
			logger.error("文件读写错误!", e);
		}
		return null;
	}
	
	/**
	 * 功能 : 下载文件
	 * 开发：zwwang 2015-5-7 下午9:11:04
	 * @param fileName 文件名称
	 * @param fileType 文件类型
	 * @param filePath 文件路径
	 * @param response
	 * @throws IOException
	 */
	public static void downLoadFile(String fileName, String filePath, HttpServletResponse response) throws IOException {
		fileName = java.net.URLEncoder.encode(fileName, "UTF-8");
		fileName = fileName.replace("+", "%20");   //encode后替换  解决空格问题
		File file = new File(properties.getProperty("upload.file.path")+"\\"+filePath);
		//文件的真实类型
//		String fileType = file.getName().substring(file.getName().lastIndexOf(".")+1).toLowerCase();
		response.setContentType("MediaType.APPLICATION_OCTET_STREAM;charset=UTF-8");
		response.setHeader("Content-Disposition", "attachment;filename=" + fileName );
        InputStream in = null;
		ServletOutputStream servletOutputStream = null;
        try {
        	in = new FileInputStream(file);
 			servletOutputStream = response.getOutputStream();
 			final int size = 1024;
 			byte[] buffer = new byte[size];
 			int length;
 			while ((length = in.read(buffer)) > 0) {
 				servletOutputStream.write(buffer, 0, length);
 			}
 		} finally {
 			try {
 				if(servletOutputStream != null) {
 					servletOutputStream.flush();
 	 				servletOutputStream.close();
 				}
 			} finally {
 				if(in != null) {
 					in.close();
 				}
 			}
 		}
	}
	
	public static void downLoadFile(String filePath, HttpServletResponse response) throws IOException {	
		File file = new File(filePath);
		String fileName = java.net.URLEncoder.encode(file.getName(), "UTF-8");
		response.setContentType("MediaType.APPLICATION_OCTET_STREAM;charset=UTF-8");
		response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        InputStream in = null;
		ServletOutputStream servletOutputStream = null;
        try {
        	in = new FileInputStream(file);
 			servletOutputStream = response.getOutputStream();
 			final int size = 1024;
 			byte[] buffer = new byte[size];
 			int length;
 			while ((length = in.read(buffer)) > 0) {
 				servletOutputStream.write(buffer, 0, length);
 			}
 		} finally {
 			try {
 				if(servletOutputStream != null) {
 					servletOutputStream.flush();
 	 				servletOutputStream.close();
 				}
 			} finally {
 				if(in != null) {
 					in.close();
 				}
 			}
 		}
	}
}
