
package com.kdgc.framework.web.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/*******************************************************************************
 *  功能说明: 树节点
  
 *  2015-3-23 下午8:38:20 zwwang 创建文件
 * 
 *  修改说明: 创建文件

 *  2015-3-23 下午8:38:20 zwwang 修改文件
 * 
 ******************************************************************************/

public class TreeNode {
	
	private String id;//id 节点的VALUE
	private String text;// 节点显示的文字
	private String iconCls;//节点的图标
	private String href; //地址路径  
	private boolean leaf;         //是否叶子   
	private boolean expanded;//节点的展开状态
	private boolean expandable; //如果设置为true，此节点将一直显示一个+/-号，甚至为空的时候也显示。
	private Map<String,Object> attributes=new HashMap<String,Object>(); //节点附加属性
	private List<TreeNode> children;//节点的子节点(异步加载时为空)
	
	public TreeNode(){};
	
	public TreeNode(String id, String text) {
		this.id = id;
		this.text = text;
	}

	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public String getIconCls() {
		return iconCls;
	}
	public void setIconCls(String iconCls) {
		this.iconCls = iconCls;
	}
	public boolean isLeaf() {
		return leaf;
	}
	public void setLeaf(boolean leaf) {
		this.leaf = leaf;
	}
	public String getHref() {
		return href;
	}

	public void setHref(String href) {
		this.href = href;
	}

	public boolean isExpanded() {
		return expanded;
	}

	public void setExpanded(boolean expanded) {
		this.expanded = expanded;
	}

	public boolean isExpandable() {
		return expandable;
	}

	public void setExpandable(boolean expandable) {
		this.expandable = expandable;
	}

	public Map<String, Object> getAttributes() {
		return attributes;
	}
	
	public void setAttributes(Map<String, Object> attributes) {
		this.attributes = attributes;
	}
	
	public void addAttributes(String key,String value) {
		this.attributes.put(key, value);
	}
	
	public List<TreeNode> getChildren() {
		return children;
	}
	public void setChildren(List<TreeNode> children) {
		this.children = children;
	}
	public void addChild(TreeNode node) {
		if(children==null){
			children=new ArrayList<TreeNode>();
		}
		children.add(node);
	}
}
